/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;
import com.gs.collections.api.bag.primitive.CharBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.primitive.CharBags;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableCharEmptyBag is an optimization for {@link ImmutableCharBag} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableCharEmptyBag implements ImmutableCharBag, Serializable
{
    static final ImmutableCharBag INSTANCE = new ImmutableCharEmptyBag();

    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ImmutableCharBag newWith(char element)
    {
        return new ImmutableCharSingletonBag(element);
    }

    public ImmutableCharBag newWithout(char element)
    {
        return this;
    }

    public ImmutableCharBag newWithAll(CharIterable elements)
    {
        return CharBags.immutable.withAll(elements);
    }

    public ImmutableCharBag newWithoutAll(CharIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public boolean contains(char value)
    {
        return false;
    }

    public boolean containsAll(CharIterable source)
    {
        return source.isEmpty();
    }

    public boolean containsAll(char... elements)
    {
        return elements.length == 0;
    }

    public void forEach(CharProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
    }

    public ImmutableCharBag select(CharPredicate predicate)
    {
        return this;
    }

    public ImmutableCharBag reject(CharPredicate predicate)
    {
        return this;
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Bags.immutable.of();
    }

    public MutableCharList toList()
    {
        return new CharArrayList();
    }

    public int sizeDistinct()
    {
        return 0;
    }

    public int occurrencesOf(char item)
    {
        return 0;
    }

    public void forEachWithOccurrences(CharIntProcedure charIntProcedure)
    {
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return ifNone;
    }

    public int count(CharPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return false;
    }

    public long sum()
    {
        return 0L;
    }

    public char min()
    {
        throw new NoSuchElementException();
    }

    public char max()
    {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public char[] toSortedArray()
    {
        return new char[0];
    }

    public MutableCharList toSortedList()
    {
        return new CharArrayList();
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharBag))
        {
            return false;
        }
        CharBag bag = (CharBag) obj;
        return bag.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    public MutableCharSet toSet()
    {
        return new CharHashSet();
    }

    public MutableCharBag toBag()
    {
        return new CharHashBag();
    }

    public ImmutableCharBag toImmutable()
    {
        return this;
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public char[] toArray()
    {
        return new char[0];
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public CharIterator charIterator()
    {
        return ImmutableEmptyCharIterator.INSTANCE;
    }
}
