/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableCharCollection;
import com.gs.collections.impl.factory.primitive.CharBags;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableCharBag
        extends AbstractUnmodifiableCharCollection
        implements MutableCharBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableCharBag(MutableCharBag bag)
    {
        super(bag);
    }

    private MutableCharBag getMutableCharBag()
    {
        return (MutableCharBag) this.getCharCollection();
    }

    @Override
    public UnmodifiableCharBag with(char element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharBag without(char element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharBag withAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableCharBag withoutAll(CharIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(char item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(char item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct()
    {
        return this.getMutableCharBag().sizeDistinct();
    }

    public int occurrencesOf(char item)
    {
        return this.getMutableCharBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(CharIntProcedure procedure)
    {
        this.getMutableCharBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableCharBag select(CharPredicate predicate)
    {
        return this.getMutableCharBag().select(predicate);
    }

    @Override
    public MutableCharBag reject(CharPredicate predicate)
    {
        return this.getMutableCharBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.getMutableCharBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableCharBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableCharBag().hashCode();
    }

    @Override
    public MutableCharBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableCharBag asSynchronized()
    {
        return new SynchronizedCharBag(this);
    }

    @Override
    public ImmutableCharBag toImmutable()
    {
        return CharBags.immutable.withAll(this);
    }
}
