/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.iterator;

import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.MutableFloatIterator;

/**
 * UnmodifiableFloatIterator is a wrapper around FloatIterator which is unmodifiable and doesn't support remove.
 * This file was automatically generated from template file unmodifiablePrimitiveIterator.stg.
 */
public class UnmodifiableFloatIterator implements MutableFloatIterator
{
    private final FloatIterator floatIterator;

    public UnmodifiableFloatIterator(FloatIterator floatIterator)
    {
        this.floatIterator = floatIterator;
    }

    public boolean hasNext()
    {
        return this.floatIterator.hasNext();
    }

    public float next()
    {
        return this.floatIterator.next();
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }
}
