/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToCharFunction;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.CharIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectDoubleToCharIterable
        extends AbstractLazyCharIterable
{
    private final DoubleIterable iterable;
    private final DoubleToCharFunction function;

    public CollectDoubleToCharIterable(DoubleIterable iterable, DoubleToCharFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final CharProcedure procedure)
    {
        this.iterable.forEach(new DoubleProcedure()
        {
            public void value(double each)
            {
                procedure.value(CollectDoubleToCharIterable.this.function.valueOf(each));
            }
        });
    }

    public CharIterator charIterator()
    {
        return new CharIterator()
        {
            private final DoubleIterator iterator = CollectDoubleToCharIterable.this.iterable.doubleIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public char next()
            {
                return CollectDoubleToCharIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
