/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToIntFunction;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.IntIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectFloatToIntIterable
        extends AbstractLazyIntIterable
{
    private final FloatIterable iterable;
    private final FloatToIntFunction function;

    public CollectFloatToIntIterable(FloatIterable iterable, FloatToIntFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final IntProcedure procedure)
    {
        this.iterable.forEach(new FloatProcedure()
        {
            public void value(float each)
            {
                procedure.value(CollectFloatToIntIterable.this.function.valueOf(each));
            }
        });
    }

    public IntIterator intIterator()
    {
        return new IntIterator()
        {
            private final FloatIterator iterator = CollectFloatToIntIterable.this.iterable.floatIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public int next()
            {
                return CollectFloatToIntIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
