/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToFloatFunction;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.FloatIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectIntToFloatIterable
        extends AbstractLazyFloatIterable
{
    private final IntIterable iterable;
    private final IntToFloatFunction function;

    public CollectIntToFloatIterable(IntIterable iterable, IntToFloatFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final FloatProcedure procedure)
    {
        this.iterable.forEach(new IntProcedure()
        {
            public void value(int each)
            {
                procedure.value(CollectIntToFloatIterable.this.function.valueOf(each));
            }
        });
    }

    public FloatIterator floatIterator()
    {
        return new FloatIterator()
        {
            private final IntIterator iterator = CollectIntToFloatIterable.this.iterable.intIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public float next()
            {
                return CollectIntToFloatIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
