/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.block.factory.primitive.BooleanPredicates;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;

/**
 * This file was automatically generated from template file selectPrimitiveIterable.stg.
 */
public class SelectBooleanIterable
        extends AbstractLazyBooleanIterable
{
    private final BooleanIterable delegate;
    private final BooleanPredicate predicate;

    public SelectBooleanIterable(BooleanIterable delegate, BooleanPredicate predicate)
    {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public BooleanIterator booleanIterator()
    {
        return new SelectBooleanIterator(this.delegate, this.predicate);
    }

    /**
     * @since 7.0.
     */
    public void each(BooleanProcedure procedure)
    {
        this.delegate.forEach(new IfBooleanProcedure(procedure));
    }

    @Override
    public int size()
    {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty()
    {
        return !this.booleanIterator().hasNext();
    }

    @Override
    public boolean notEmpty()
    {
        return this.booleanIterator().hasNext();
    }

    @Override
    public int count(BooleanPredicate predicate)
    {
        CountBooleanProcedure countBooleanProcedure = new CountBooleanProcedure(predicate);
        this.forEach(countBooleanProcedure);
        return countBooleanProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.delegate.anySatisfy(BooleanPredicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.noneSatisfy(BooleanPredicates.not(predicate));
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return !this.anySatisfy(predicate);
    }

    @Override
    public boolean[] toArray()
    {
        final boolean[] array = new boolean[this.size()];
        this.forEach(new BooleanProcedure()
        {
            @SuppressWarnings("FieldMayBeFinal")
            private int index = 0;
            public void value(boolean each)
            {
                array[this.index++] = each;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(boolean... source)
    {
        for (boolean value : source)
        {
            if (!this.contains(value))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(BooleanIterable source)
    {
        for (BooleanIterator iterator = source.booleanIterator(); iterator.hasNext(); )
        {
            if (!this.contains(iterator.next()))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public MutableBooleanList toList()
    {
        return BooleanArrayList.newList(this);
    }

    @Override
    public MutableBooleanSet toSet()
    {
        return BooleanHashSet.newSet(this);
    }

    @Override
    public MutableBooleanBag toBag()
    {
        return BooleanHashBag.newBag(this);
    }

    private static final class CountBooleanProcedure implements BooleanProcedure
    {
        private static final long serialVersionUID = 1L;
        private final BooleanPredicate predicate;
        private int counter = 0;

        private CountBooleanProcedure(BooleanPredicate predicate)
        {
            this.predicate = predicate;
        }

        public void value(boolean each)
        {
            if (this.predicate.accept(each))
            {
                this.counter++;
            }
        }

        public int getCount()
        {
            return this.counter;
        }
    }

    private final class IfBooleanProcedure implements BooleanProcedure
    {
        private static final long serialVersionUID = 1L;
        private final BooleanProcedure procedure;

        private IfBooleanProcedure(BooleanProcedure procedure)
        {
            this.procedure = procedure;
        }

        public void value(boolean each)
        {
            if (SelectBooleanIterable.this.predicate.accept(each))
            {
                this.procedure.value(each);
            }
        }
    }

    private static final class SelectBooleanIterator
            implements BooleanIterator
    {
        private final BooleanIterator iterator;
        private final BooleanPredicate predicate;
        private boolean next;
        private boolean verifiedHasNext = false;

        private SelectBooleanIterator(BooleanIterable iterable, BooleanPredicate predicate)
        {
            this(iterable.booleanIterator(), predicate);
        }

        private SelectBooleanIterator(BooleanIterator iterator, BooleanPredicate predicate)
        {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext()
        {
            if (this.verifiedHasNext)
            {
                return true;
            }
            while (this.iterator.hasNext())
            {
                boolean temp = this.iterator.next();
                if (this.predicate.accept(temp))
                {
                    this.next = temp;
                    this.verifiedHasNext = true;
                    return true;
                }
            }
            return false;
        }

        public boolean next()
        {
            if (this.verifiedHasNext || this.hasNext())
            {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}
