/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.iterator.ImmutableEmptyCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseCharIterable;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableCharEmptyList is an optimization for {@link ImmutableCharList} of size 0.
 * This file was automatically generated from template file immutablePrimitiveEmptyList.stg.
 */
@Immutable
final class ImmutableCharEmptyList implements ImmutableCharList, Serializable
{
    static final ImmutableCharList INSTANCE = new ImmutableCharEmptyList();
    private static final long serialVersionUID = 1L;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public char get(int index)
    {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    public char getFirst()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public char getLast()
    {
        throw new IndexOutOfBoundsException("Index: 0, Size: 0");
    }

    public int indexOf(char value)
    {
        return -1;
    }

    public int lastIndexOf(char value)
    {
        return -1;
    }

    public CharIterator charIterator()
    {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
    }

    public void forEachWithIndex(CharIntProcedure procedure)
    {
    }

    public int count(CharPredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return true;
    }

    public ImmutableCharList select(CharPredicate predicate)
    {
        return this;
    }

    public ImmutableCharList reject(CharPredicate predicate)
    {
        return this;
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public long sum()
    {
        return 0;
    }

    public char max()
    {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public char min()
    {
        throw new NoSuchElementException();
    }

    public char minIfEmpty(char defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public char[] toSortedArray()
    {
        return new char[0];
    }

    public MutableCharList toSortedList()
    {
        return new CharArrayList();
    }

    public int binarySearch(char value)
    {
        return -1;
    }

    public long dotProduct(CharList list)
    {
        if (!list.isEmpty())
        {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return 0;
    }

    public char[] toArray()
    {
        return new char[0];
    }

    public boolean contains(char value)
    {
        return false;
    }

    public boolean containsAll(char... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source)
    {
        return source.isEmpty();
    }

    public LazyCharIterable asReversed()
    {
        return ReverseCharIterable.adapt(this);
    }

    public MutableCharList toList()
    {
        return new CharArrayList();
    }

    public MutableCharSet toSet()
    {
        return new CharHashSet();
    }

    public MutableCharBag toBag()
    {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableCharList toImmutable()
    {
        return this;
    }

    public ImmutableCharEmptyList toReversed()
    {
        return this;
    }

    public ImmutableCharList newWith(char element)
    {
        return CharLists.immutable.with(element);
    }

    public ImmutableCharList newWithout(char element)
    {
        return this;
    }

    public ImmutableCharList newWithAll(CharIterable elements)
    {
        return CharLists.immutable.withAll(elements);
    }

    public ImmutableCharList newWithoutAll(CharIterable elements)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherList)
    {
        if (otherList == this)
        {
            return true;
        }
        if (!(otherList instanceof CharList))
        {
            return false;
        }
        CharList list = (CharList) otherList;
        return list.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    @Override
    public String toString()
    {
        return "[]";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    /**
     * @since 6.0.
     */
    public ImmutableCharList distinct()
    {
        return INSTANCE;
    }

    public ImmutableCharList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
