/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleCharMap;
import com.gs.collections.api.map.primitive.DoubleCharMap;

/**
 * ImmutableDoubleCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleCharMapFactoryImpl implements ImmutableDoubleCharMapFactory
{
    public ImmutableDoubleCharMap empty()
    {
        return ImmutableDoubleCharEmptyMap.INSTANCE;
    }

    public ImmutableDoubleCharMap of()
    {
        return this.empty();
    }

    public ImmutableDoubleCharMap with()
    {
        return this.empty();
    }

    public ImmutableDoubleCharMap of(double key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleCharMap with(double key, char value)
    {
        return new ImmutableDoubleCharSingletonMap(key, value);
    }

    public ImmutableDoubleCharMap ofAll(DoubleCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleCharMap withAll(DoubleCharMap map)
    {
        if (map instanceof ImmutableDoubleCharMap)
        {
            return (ImmutableDoubleCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleCharSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleCharHashMap(map);
    }
}
