/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleFloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.DoubleFloatMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleFloatMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.DoubleFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleFloatMaps;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.DoubleFloatHashMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableDoubleFloatSingletonMap is an optimization for {@link ImmutableDoubleFloatMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableDoubleFloatSingletonMap implements ImmutableDoubleFloatMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final double key1;
    private final float value1;

    ImmutableDoubleFloatSingletonMap(double key1, float value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public float get(double key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public float getIfAbsent(double key, float ifAbsent)
    {
        return Double.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public float getOrThrow(double key)
    {
        if (Double.compare(this.key1, key) == 0)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key)
    {
        return Double.compare(this.key1, key) == 0;
    }

    public boolean containsValue(float value)
    {
        return Float.compare(this.value1, value) == 0;
    }

    public void forEachValue(FloatProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(DoubleProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(DoubleFloatProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyDoubleIterable keysView()
    {
        return DoubleLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<DoubleFloatPair> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableDoubleFloatMap select(DoubleFloatPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? DoubleFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new DoubleFloatHashMap().toImmutable();
    }

    public ImmutableDoubleFloatMap reject(DoubleFloatPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new DoubleFloatHashMap().toImmutable()
                : DoubleFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableDoubleFloatMap toImmutable()
    {
        return this;
    }

    public FloatIterator floatIterator()
    {
        return new UnmodifiableFloatIterator(DoubleFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    public void forEach(FloatProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(FloatProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public double sum()
    {
        return this.value1;
    }

    public float min()
    {
        return this.value1;
    }

    public float max()
    {
        return this.value1;
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.value1;
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public float[] toSortedArray()
    {
        return new float[]{this.value1};
    }

    public MutableFloatList toSortedList()
    {
        return FloatArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableFloatCollection select(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? FloatArrayList.newListWith(this.value1).toImmutable() : new FloatArrayList().toImmutable();
    }

    public ImmutableFloatCollection reject(FloatPredicate predicate)
    {
        return predicate.accept(this.value1) ? new FloatArrayList().toImmutable() : FloatArrayList.newListWith(this.value1).toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public float[] toArray()
    {
        return new float[]{this.value1};
    }

    public boolean contains(float value)
    {
        return Float.compare(this.value1, value) == 0;
    }

    public boolean containsAll(float... source)
    {
        for (float value : source)
        {
            if (Float.compare(this.value1, value) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(FloatIterable source)
    {
        for (FloatIterator iterator = source.floatIterator(); iterator.hasNext(); )
        {
            if (Float.compare(this.value1, iterator.next()) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public MutableFloatList toList()
    {
        return FloatArrayList.newListWith(this.value1);
    }

    public MutableFloatSet toSet()
    {
        return FloatHashSet.newSetWith(this.value1);
    }

    public MutableFloatBag toBag()
    {
        return FloatHashBag.newBagWith(this.value1);
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public ImmutableDoubleFloatMap newWithKeyValue(double key, float value)
    {
        return DoubleFloatMaps.immutable.withAll(DoubleFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableDoubleFloatMap newWithoutKey(double key)
    {
        return Double.compare(this.key1, key) == 0 ? DoubleFloatMaps.immutable.with() : this;
    }

    public ImmutableDoubleFloatMap newWithoutAllKeys(DoubleIterable keys)
    {
        return keys.contains(this.key1) ? DoubleFloatMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableDoubleSet keySet()
    {
        return UnmodifiableDoubleSet.of(DoubleHashSet.newSetWith(this.key1));
    }

    public MutableFloatCollection values()
    {
        return UnmodifiableFloatCollection.of(FloatArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof DoubleFloatMap))
        {
            return false;
        }
        DoubleFloatMap map = (DoubleFloatMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && Float.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode()
    {
        return (int) (Double.doubleToLongBits(this.key1) ^ Double.doubleToLongBits(this.key1) >>> 32) ^ Float.floatToIntBits(this.value1);
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
