/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ShortBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableShortBooleanMap;
import com.gs.collections.api.map.primitive.MutableShortBooleanMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.ShortBooleanPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedShortBooleanProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.map.mutable.primitive.ShortBooleanHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/**
 * ImmutableShortBooleanHashMap is the non-modifiable equivalent of {@link ShortBooleanHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableShortBooleanHashMap implements ImmutableShortBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableShortBooleanMap delegate;

    ImmutableShortBooleanHashMap(ShortBooleanMap delegate)
    {
        this.delegate = new ShortBooleanHashMap(delegate);
    }

    public boolean get(short key)
    {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(short key, boolean ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(short key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortBooleanProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ShortBooleanPair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableShortBooleanMap select(ShortBooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortBooleanMap reject(ShortBooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableShortBooleanMap toImmutable()
    {
        return this;
    }

    public BooleanIterator booleanIterator()
    {
        return new UnmodifiableBooleanIterator(this.delegate.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(BooleanProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public boolean[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableShortBooleanMap newWithKeyValue(short key, boolean value)
    {
        MutableShortBooleanMap map = new ShortBooleanHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortBooleanMap newWithoutKey(short key)
    {
        MutableShortBooleanMap map = new ShortBooleanHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortBooleanMap newWithoutAllKeys(ShortIterable keys)
    {
        MutableShortBooleanMap map = new ShortBooleanHashMap(this.size());
        map.putAll(this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet()
    {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableShortBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableShortBooleanMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private ShortBooleanMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableShortBooleanMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableShortBooleanMapSerializationProxy(ShortBooleanMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedShortBooleanProcedure()
                {
                    @Override
                    public void safeValue(short key, boolean value) throws IOException
                    {
                        out.writeShort(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableShortBooleanMap deserializedMap = new ShortBooleanHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readShort(), in.readBoolean());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
