/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.set.primitive.MutableIntSetFactory;
import com.gs.collections.api.set.primitive.MutableIntSet;

/**
 * MutableIntSetFactoryImpl is a factory implementation which creates instances of type {@link MutableIntSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableIntSetFactoryImpl implements MutableIntSetFactory
{
    public MutableIntSet empty()
    {
        return new IntHashSet();
    }

    public MutableIntSet of()
    {
        return this.empty();
    }

    public MutableIntSet with()
    {
        return this.empty();
    }

    public MutableIntSet of(int... items)
    {
        return this.with(items);
    }

    public MutableIntSet with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return IntHashSet.newSetWith(items);
    }

    public MutableIntSet ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public MutableIntSet withAll(IntIterable items)
    {
        return IntHashSet.newSet(items);
    }
}
