/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.util.NoSuchElementException;

public class SelectIntIterable
extends AbstractLazyIntIterable {
    private final IntIterable delegate;
    private final IntPredicate predicate;

    public SelectIntIterable(IntIterable delegate, IntPredicate predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public IntIterator intIterator() {
        return new SelectIntIterator(this.delegate, this.predicate);
    }

    public void each(IntProcedure procedure) {
        this.delegate.forEach((IntProcedure)new IfIntProcedure(procedure));
    }

    public int size() {
        return this.delegate.count(this.predicate);
    }

    public boolean isEmpty() {
        return !this.intIterator().hasNext();
    }

    public boolean notEmpty() {
        return this.intIterator().hasNext();
    }

    public int count(IntPredicate predicate) {
        CountIntProcedure countIntProcedure = new CountIntProcedure(predicate);
        this.forEach(countIntProcedure);
        return countIntProcedure.getCount();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(IntPredicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.noneSatisfy(IntPredicates.not(predicate));
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public int[] toArray() {
        final int[] array = new int[this.size()];
        this.forEach(new IntProcedure(){
            private int index = 0;

            public void value(int each) {
                array[this.index++] = each;
            }
        });
        return array;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    private static final class SelectIntIterator
    implements IntIterator {
        private final IntIterator iterator;
        private final IntPredicate predicate;
        private int next;
        private boolean verifiedHasNext = false;

        private SelectIntIterator(IntIterable iterable, IntPredicate predicate) {
            this(iterable.intIterator(), predicate);
        }

        private SelectIntIterator(IntIterator iterator, IntPredicate predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext() {
            if (this.verifiedHasNext) {
                return true;
            }
            while (this.iterator.hasNext()) {
                int temp = this.iterator.next();
                if (!this.predicate.accept(temp)) continue;
                this.next = temp;
                this.verifiedHasNext = true;
                return true;
            }
            return false;
        }

        public int next() {
            if (this.verifiedHasNext || this.hasNext()) {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }

    private final class IfIntProcedure
    implements IntProcedure {
        private static final long serialVersionUID = 1L;
        private final IntProcedure procedure;

        private IfIntProcedure(IntProcedure procedure) {
            this.procedure = procedure;
        }

        public void value(int each) {
            if (SelectIntIterable.this.predicate.accept(each)) {
                this.procedure.value(each);
            }
        }
    }

    private static final class CountIntProcedure
    implements IntProcedure {
        private static final long serialVersionUID = 1L;
        private final IntPredicate predicate;
        private int counter = 0;

        private CountIntProcedure(IntPredicate predicate) {
            this.predicate = predicate;
        }

        public void value(int each) {
            if (this.predicate.accept(each)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

