/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.stack.primitive.MutableCharStackFactory;
import com.gs.collections.api.stack.primitive.MutableCharStack;
import com.gs.collections.impl.stack.mutable.primitive.CharArrayStack;

public class MutableCharStackFactoryImpl
implements MutableCharStackFactory {
    public MutableCharStack empty() {
        return new CharArrayStack();
    }

    public MutableCharStack of() {
        return this.empty();
    }

    public MutableCharStack with() {
        return this.empty();
    }

    public MutableCharStack of(char ... items) {
        return this.with(items);
    }

    public MutableCharStack with(char ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return CharArrayStack.newStackWith(items);
    }

    public MutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public MutableCharStack withAll(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStack(items);
    }

    public MutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    public MutableCharStack withAllReversed(CharIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return CharArrayStack.newStackFromTopToBottom(items);
    }
}

