/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.iterator;

import java.util.NoSuchElementException;

import com.gs.collections.api.iterator.DoubleIterator;

/**
 * This file was automatically generated from template file primitiveImmutableEmptyIterator.stg.
 */
public final class ImmutableEmptyDoubleIterator implements DoubleIterator
{
    public static final ImmutableEmptyDoubleIterator INSTANCE = new ImmutableEmptyDoubleIterator();

    private ImmutableEmptyDoubleIterator()
    {
    }

    public boolean hasNext()
    {
        return false;
    }

    public double next()
    {
        throw new NoSuchElementException();
    }
}
