/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToCharFunction;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.CharIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectIntToCharIterable
        extends AbstractLazyCharIterable
{
    private final IntIterable iterable;
    private final IntToCharFunction function;

    public CollectIntToCharIterable(IntIterable iterable, IntToCharFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final CharProcedure procedure)
    {
        this.iterable.forEach(new IntProcedure()
        {
            public void value(int each)
            {
                procedure.value(CollectIntToCharIterable.this.function.valueOf(each));
            }
        });
    }

    public CharIterator charIterator()
    {
        return new CharIterator()
        {
            private final IntIterator iterator = CollectIntToCharIterable.this.iterable.intIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public char next()
            {
                return CollectIntToCharIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
