/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToByteFunction;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.iterator.ByteIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectLongToByteIterable
        extends AbstractLazyByteIterable
{
    private final LongIterable iterable;
    private final LongToByteFunction function;

    public CollectLongToByteIterable(LongIterable iterable, LongToByteFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final ByteProcedure procedure)
    {
        this.iterable.forEach(new LongProcedure()
        {
            public void value(long each)
            {
                procedure.value(CollectLongToByteIterable.this.function.valueOf(each));
            }
        });
    }

    public ByteIterator byteIterator()
    {
        return new ByteIterator()
        {
            private final LongIterator iterator = CollectLongToByteIterable.this.iterable.longIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public byte next()
            {
                return CollectLongToByteIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
