/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.IntPredicates;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;

/**
 * This file was automatically generated from template file selectPrimitiveIterable.stg.
 */
public class SelectIntIterable
        extends AbstractLazyIntIterable
{
    private final IntIterable delegate;
    private final IntPredicate predicate;

    public SelectIntIterable(IntIterable delegate, IntPredicate predicate)
    {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public IntIterator intIterator()
    {
        return new SelectIntIterator(this.delegate, this.predicate);
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
        this.delegate.forEach(new IfIntProcedure(procedure));
    }

    @Override
    public int size()
    {
        return this.delegate.count(this.predicate);
    }

    @Override
    public boolean isEmpty()
    {
        return !this.intIterator().hasNext();
    }

    @Override
    public boolean notEmpty()
    {
        return this.intIterator().hasNext();
    }

    @Override
    public int count(IntPredicate predicate)
    {
        CountIntProcedure countIntProcedure = new CountIntProcedure(predicate);
        this.forEach(countIntProcedure);
        return countIntProcedure.getCount();
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate)
    {
        return this.delegate.anySatisfy(IntPredicates.and(this.predicate, predicate));
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate)
    {
        return this.noneSatisfy(IntPredicates.not(predicate));
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate)
    {
        return !this.anySatisfy(predicate);
    }

    @Override
    public int[] toArray()
    {
        final int[] array = new int[this.size()];
        this.forEach(new IntProcedure()
        {
            @SuppressWarnings("FieldMayBeFinal")
            private int index = 0;
            public void value(int each)
            {
                array[this.index++] = each;
            }
        });
        return array;
    }

    @Override
    public boolean containsAll(int... source)
    {
        for (int value : source)
        {
            if (!this.contains(value))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAll(IntIterable source)
    {
        for (IntIterator iterator = source.intIterator(); iterator.hasNext(); )
        {
            if (!this.contains(iterator.next()))
            {
                return false;
            }
        }
        return true;
    }

    @Override
    public MutableIntList toList()
    {
        return IntArrayList.newList(this);
    }

    @Override
    public MutableIntSet toSet()
    {
        return IntHashSet.newSet(this);
    }

    @Override
    public MutableIntBag toBag()
    {
        return IntHashBag.newBag(this);
    }

    private static final class CountIntProcedure implements IntProcedure
    {
        private static final long serialVersionUID = 1L;
        private final IntPredicate predicate;
        private int counter = 0;

        private CountIntProcedure(IntPredicate predicate)
        {
            this.predicate = predicate;
        }

        public void value(int each)
        {
            if (this.predicate.accept(each))
            {
                this.counter++;
            }
        }

        public int getCount()
        {
            return this.counter;
        }
    }

    private final class IfIntProcedure implements IntProcedure
    {
        private static final long serialVersionUID = 1L;
        private final IntProcedure procedure;

        private IfIntProcedure(IntProcedure procedure)
        {
            this.procedure = procedure;
        }

        public void value(int each)
        {
            if (SelectIntIterable.this.predicate.accept(each))
            {
                this.procedure.value(each);
            }
        }
    }

    private static final class SelectIntIterator
            implements IntIterator
    {
        private final IntIterator iterator;
        private final IntPredicate predicate;
        private int next;
        private boolean verifiedHasNext = false;

        private SelectIntIterator(IntIterable iterable, IntPredicate predicate)
        {
            this(iterable.intIterator(), predicate);
        }

        private SelectIntIterator(IntIterator iterator, IntPredicate predicate)
        {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        public boolean hasNext()
        {
            if (this.verifiedHasNext)
            {
                return true;
            }
            while (this.iterator.hasNext())
            {
                int temp = this.iterator.next();
                if (this.predicate.accept(temp))
                {
                    this.next = temp;
                    this.verifiedHasNext = true;
                    return true;
                }
            }
            return false;
        }

        public int next()
        {
            if (this.verifiedHasNext || this.hasNext())
            {
                this.verifiedHasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}
