/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongByteMap;
import com.gs.collections.api.map.primitive.LongByteMap;

/**
 * ImmutableLongByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongByteMapFactoryImpl implements ImmutableLongByteMapFactory
{
    public ImmutableLongByteMap empty()
    {
        return ImmutableLongByteEmptyMap.INSTANCE;
    }

    public ImmutableLongByteMap of()
    {
        return this.empty();
    }

    public ImmutableLongByteMap with()
    {
        return this.empty();
    }

    public ImmutableLongByteMap of(long key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableLongByteMap with(long key, byte value)
    {
        return new ImmutableLongByteSingletonMap(key, value);
    }

    public ImmutableLongByteMap ofAll(LongByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongByteMap withAll(LongByteMap map)
    {
        if (map instanceof ImmutableLongByteMap)
        {
            return (ImmutableLongByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongByteSingletonMap(key, map.get(key));
        }
        return new ImmutableLongByteHashMap(map);
    }
}
