/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectCharPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectCharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableObjectCharMap;
import com.gs.collections.api.map.primitive.ObjectCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.tuple.primitive.ObjectCharPair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.ObjectCharMaps;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.ObjectCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableObjectCharSingletonMap is an optimization for {@link ImmutableObjectCharMap} of size 1.
 * This file was automatically generated from template file immutableObjectPrimitiveSingletonMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectCharSingletonMap<K> extends AbstractImmutableObjectCharMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';
    private final K key1;
    private final char value1;

    ImmutableObjectCharSingletonMap(K key1, char value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public CharIterator charIterator()
    {
        return new UnmodifiableCharIterator(ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? CharLists.immutable.with(this.value1) : CharLists.immutable.with();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? CharLists.immutable.with() : CharLists.immutable.with(this.value1);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum()
    {
        return this.value1;
    }

    public char min()
    {
        return this.value1;
    }

    public char max()
    {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public char[] toSortedArray()
    {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public char[] toArray()
    {
        return new char[]{this.value1};
    }

    public boolean contains(char value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(char... source)
    {
        for (char value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(CharIterable source)
    {
        for (CharIterator iterator = source.charIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableCharList toList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet()
    {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag()
    {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableObjectCharMap<K> newWithKeyValue(K key, char value)
    {
        return ObjectCharMaps.immutable.withAll(ObjectCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectCharMap<K> newWithoutKey(K key)
    {
        return nullSafeEquals(this.key1, key) ? (ImmutableObjectCharMap<K>) ImmutableObjectCharEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other)
    {
        if (value == null)
        {
            if (other == null)
            {
                return true;
            }
        }
        else if (other == value || value.equals(other))
        {
            return true;
        }
        return false;
    }

    public ImmutableObjectCharMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectCharHashMap<K> map = new ObjectCharHashMap<K>(this);
        for (K key : keys)
        {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public char get(Object key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public char getOrThrow(Object key)
    {
        if (nullSafeEquals(this.key1, key))
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public char getIfAbsent(Object key, char ifAbsent)
    {
        return nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(char value)
    {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectCharProcedure<? super K> objectCharProcedure)
    {
        objectCharProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectCharMap<K> select(ObjectCharPredicate<? super K> objectCharPredicate)
    {
        return objectCharPredicate.accept(this.key1, this.value1) ? ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : (ImmutableObjectCharMap<K>) ImmutableObjectCharEmptyMap.INSTANCE;
    }

    public ImmutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> objectCharPredicate)
    {
        return objectCharPredicate.accept(this.key1, this.value1) ? (ImmutableObjectCharMap<K>) ImmutableObjectCharEmptyMap.INSTANCE
                : ObjectCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectCharMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(CharArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView()
    {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectCharPair<K>> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectCharMap))
        {
            return false;
        }
        ObjectCharMap<K> map = (ObjectCharMap<K>) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ (int) this.value1;
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace()
    {
        return new ImmutableObjectCharMapSerializationProxy<K>(this);
    }
}
