/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.tuple.primitive.ObjectDoublePair;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.ObjectDoubleMaps;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;

/**
 * ImmutableObjectDoubleSingletonMap is an optimization for {@link ImmutableObjectDoubleMap} of size 1.
 * This file was automatically generated from template file immutableObjectPrimitiveSingletonMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectDoubleSingletonMap<K> extends AbstractImmutableObjectDoubleMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    private final K key1;
    private final double value1;

    ImmutableObjectDoubleSingletonMap(K key1, double value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(ObjectDoubleHashMap.newWithKeysValues(this.key1, this.value1).doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? DoubleLists.immutable.with(this.value1) : DoubleLists.immutable.with();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return predicate.accept(this.value1) ? DoubleLists.immutable.with() : DoubleLists.immutable.with(this.value1);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public double sum()
    {
        return this.value1;
    }

    public double min()
    {
        return this.value1;
    }

    public double max()
    {
        return this.value1;
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.value1;
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public double[] toSortedArray()
    {
        return new double[]{this.value1};
    }

    public MutableDoubleList toSortedList()
    {
        return DoubleArrayList.newListWith(this.value1);
    }

    public double[] toArray()
    {
        return new double[]{this.value1};
    }

    public boolean contains(double value)
    {
        return Double.compare(this.value1, value) == 0;
    }

    public boolean containsAll(double... source)
    {
        for (double value : source)
        {
            if (Double.compare(this.value1, value) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source)
    {
        for (DoubleIterator iterator = source.doubleIterator(); iterator.hasNext(); )
        {
            if (Double.compare(this.value1, iterator.next()) != 0)
            {
                return false;
            }
        }
        return true;
    }

    public MutableDoubleList toList()
    {
        return DoubleArrayList.newListWith(this.value1);
    }

    public MutableDoubleSet toSet()
    {
        return DoubleHashSet.newSetWith(this.value1);
    }

    public MutableDoubleBag toBag()
    {
        return DoubleHashBag.newBagWith(this.value1);
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public ImmutableObjectDoubleMap<K> newWithKeyValue(K key, double value)
    {
        return ObjectDoubleMaps.immutable.withAll(ObjectDoubleHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectDoubleMap<K> newWithoutKey(K key)
    {
        return nullSafeEquals(this.key1, key) ? (ImmutableObjectDoubleMap<K>) ImmutableObjectDoubleEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other)
    {
        if (value == null)
        {
            if (other == null)
            {
                return true;
            }
        }
        else if (other == value || value.equals(other))
        {
            return true;
        }
        return false;
    }

    public ImmutableObjectDoubleMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectDoubleHashMap<K> map = new ObjectDoubleHashMap<K>(this);
        for (K key : keys)
        {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public double get(Object key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public double getOrThrow(Object key)
    {
        if (nullSafeEquals(this.key1, key))
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public double getIfAbsent(Object key, double ifAbsent)
    {
        return nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(double value)
    {
        return Double.compare(this.value1, value) == 0;
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> objectDoubleProcedure)
    {
        objectDoubleProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return objectDoublePredicate.accept(this.key1, this.value1) ? ObjectDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : (ImmutableObjectDoubleMap<K>) ImmutableObjectDoubleEmptyMap.INSTANCE;
    }

    public ImmutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return objectDoublePredicate.accept(this.key1, this.value1) ? (ImmutableObjectDoubleMap<K>) ImmutableObjectDoubleEmptyMap.INSTANCE
                : ObjectDoubleHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectDoubleMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableDoubleCollection values()
    {
        return UnmodifiableDoubleCollection.of(DoubleArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView()
    {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectDoublePair<K>> keyValuesView()
    {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectDoubleMap))
        {
            return false;
        }
        ObjectDoubleMap<K> map = (ObjectDoubleMap<K>) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && Double.compare(this.value1, map.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode()
    {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ (int) (Double.doubleToLongBits(this.value1) ^ Double.doubleToLongBits(this.value1) >>> 32);
    }

    @Override
    public String toString()
    {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace()
    {
        return new ImmutableObjectDoubleMapSerializationProxy<K>(this);
    }
}
