/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ByteToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.MutableBooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableByteBooleanMap;
import com.gs.collections.api.map.primitive.ByteBooleanMap;
import com.gs.collections.api.map.primitive.MutableByteBooleanMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.ByteBooleanPair;
import com.gs.collections.impl.factory.primitive.ByteBooleanMaps;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableByteBooleanMap
        implements MutableByteBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableByteBooleanMap map;

    UnmodifiableByteBooleanMap(MutableByteBooleanMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(byte key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(ByteBooleanMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(byte key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeKeyIfAbsent(byte key, boolean value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public boolean getIfAbsentPut(byte key, boolean value)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean getIfAbsentPut(byte key, BooleanFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean getIfAbsentPutWithKey(byte key, ByteToBooleanFunction function)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> boolean getIfAbsentPutWith(byte key, BooleanFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean updateValue(byte key, boolean initialValueIfAbsent, BooleanToBooleanFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public boolean get(byte key)
    {
        return this.map.get(key);
    }

    public boolean getIfAbsent(byte key, boolean ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(byte key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(byte key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteBooleanProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<ByteBooleanPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableByteBooleanMap select(ByteBooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableByteBooleanMap reject(ByteBooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableBooleanIterator booleanIterator()
    {
        return new UnmodifiableBooleanIterator(this.map.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(BooleanProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public boolean[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.map.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.map.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.map.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableByteBooleanMap withKeyValue(byte key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableByteBooleanMap withoutKey(byte key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableByteBooleanMap withoutAllKeys(ByteIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableByteBooleanMap asUnmodifiable()
    {
        return this;
    }

    public MutableByteBooleanMap asSynchronized()
    {
        return new SynchronizedByteBooleanMap(this);
    }

    public ImmutableByteBooleanMap toImmutable()
    {
        return ByteBooleanMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableByteSet keySet()
    {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
