/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableDoubleCollection;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableDoubleSet
        extends AbstractUnmodifiableDoubleCollection
        implements MutableDoubleSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableDoubleSet(MutableDoubleSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableDoubleSet and wrap it directly in a UnmodifiableDoubleSet.
     */
    public static UnmodifiableDoubleSet of(MutableDoubleSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableDoubleSet for null");
        }
        return new UnmodifiableDoubleSet(set);
    }

    private MutableDoubleSet getMutableDoubleSet()
    {
        return (MutableDoubleSet) this.getDoubleCollection();
    }

    @Override
    public UnmodifiableDoubleSet with(double element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet without(double element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet withAll(DoubleIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleSet withoutAll(DoubleIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableDoubleSet select(DoublePredicate predicate)
    {
        return this.getMutableDoubleSet().select(predicate);
    }

    @Override
    public MutableDoubleSet reject(DoublePredicate predicate)
    {
        return this.getMutableDoubleSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.getMutableDoubleSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableDoubleSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableDoubleSet().hashCode();
    }

    @Override
    public MutableDoubleSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableDoubleSet asSynchronized()
    {
        return new SynchronizedDoubleSet(this);
    }

    public DoubleSet freeze()
    {
        return this.getMutableDoubleSet().freeze();
    }

    @Override
    public ImmutableDoubleSet toImmutable()
    {
        return this.getMutableDoubleSet().toImmutable();
    }
}
