/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.stack.primitive.MutableByteStackFactory;
import com.gs.collections.api.stack.primitive.MutableByteStack;

/**
 * MutableByteStackFactoryImpl is a factory implementation which creates instances of type {@link MutableByteStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableByteStackFactoryImpl implements MutableByteStackFactory
{
    public MutableByteStack empty()
    {
        return new ByteArrayStack();
    }

    public MutableByteStack of()
    {
        return this.empty();
    }

    public MutableByteStack with()
    {
        return this.empty();
    }

    public MutableByteStack of(byte... items)
    {
        return this.with(items);
    }

    public MutableByteStack with(byte... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return ByteArrayStack.newStackWith(items);
    }

    public MutableByteStack ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public MutableByteStack withAll(ByteIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return ByteArrayStack.newStack(items);
    }

    public MutableByteStack ofAllReversed(ByteIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableByteStack withAllReversed(ByteIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return ByteArrayStack.newStackFromTopToBottom(items);
    }
}
