/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.stack.primitive.MutableDoubleStackFactory;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;

/**
 * MutableDoubleStackFactoryImpl is a factory implementation which creates instances of type {@link MutableDoubleStack}.
 * This file was automatically generated from template file mutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableDoubleStackFactoryImpl implements MutableDoubleStackFactory
{
    public MutableDoubleStack empty()
    {
        return new DoubleArrayStack();
    }

    public MutableDoubleStack of()
    {
        return this.empty();
    }

    public MutableDoubleStack with()
    {
        return this.empty();
    }

    public MutableDoubleStack of(double... items)
    {
        return this.with(items);
    }

    public MutableDoubleStack with(double... items)
    {
        if (items.length == 0)
        {
            return this.empty();
        }
        return DoubleArrayStack.newStackWith(items);
    }

    public MutableDoubleStack ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public MutableDoubleStack withAll(DoubleIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return DoubleArrayStack.newStack(items);
    }

    public MutableDoubleStack ofAllReversed(DoubleIterable items)
    {
        return this.withAllReversed(items);
    }

    public MutableDoubleStack withAllReversed(DoubleIterable items)
    {
        if (items.isEmpty())
        {
            return this.empty();
        }
        return DoubleArrayStack.newStackFromTopToBottom(items);
    }
}
