/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.iterator;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlatCollectIterator<T, V>
implements Iterator<V> {
    private final Iterator<T> iterator;
    private final Function<? super T, ? extends Iterable<V>> function;
    private Iterator<V> innerIterator = EmptyIterator.getInstance();

    public FlatCollectIterator(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> newFunction) {
        this(iterable.iterator(), newFunction);
    }

    public FlatCollectIterator(Iterator<T> newIterator, Function<? super T, ? extends Iterable<V>> newFunction) {
        this.iterator = newIterator;
        this.function = newFunction;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a flatCollect iterator");
    }

    @Override
    public boolean hasNext() {
        while (!this.innerIterator.hasNext()) {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.innerIterator = ((Iterable)this.function.valueOf(this.iterator.next())).iterator();
        }
        return true;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.innerIterator.next();
    }
}

