/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.IfProcedure;
import com.gs.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
class ParallelSelectListIterable<T>
extends AbstractParallelListIterable<T, ListBatch<T>> {
    private final AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable;
    private final Predicate<? super T> predicate;

    ParallelSelectListIterable(AbstractParallelListIterable<T, ? extends ListBatch<T>> parallelIterable, Predicate<? super T> predicate) {
        this.parallelIterable = parallelIterable;
        this.predicate = predicate;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<T>> split() {
        return this.parallelIterable.split().collect(new Function<ListBatch<T>, ListBatch<T>>(){

            public ListBatch<T> valueOf(ListBatch<T> eachBatch) {
                return eachBatch.select(ParallelSelectListIterable.this.predicate);
            }
        });
    }

    public void forEach(Procedure<? super T> procedure) {
        this.parallelIterable.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.and(this.predicate, predicate));
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.parallelIterable.allSatisfy(new SelectAllSatisfyPredicate(this.predicate, predicate));
    }

    public T detect(Predicate<? super T> predicate) {
        return (T)this.parallelIterable.detect(Predicates.and(this.predicate, predicate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectAllSatisfyPredicate<T>
    implements Predicate<T> {
        private final Predicate<? super T> left;
        private final Predicate<? super T> right;

        private SelectAllSatisfyPredicate(Predicate<? super T> left, Predicate<? super T> right) {
            this.left = left;
            this.right = right;
        }

        public boolean accept(T each) {
            boolean leftResult = this.left.accept(each);
            return !leftResult || this.right.accept(each);
        }
    }
}

