/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedLongCollection;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedLongSet
extends AbstractSynchronizedLongCollection
implements MutableLongSet {
    private static final long serialVersionUID = 1L;

    SynchronizedLongSet(MutableLongSet set) {
        super((MutableLongCollection)set);
    }

    SynchronizedLongSet(MutableLongSet set, Object newLock) {
        super((MutableLongCollection)set, newLock);
    }

    public static SynchronizedLongSet of(MutableLongSet set) {
        return new SynchronizedLongSet(set);
    }

    public static SynchronizedLongSet of(MutableLongSet set, Object lock) {
        return new SynchronizedLongSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableLongSet getMutableLongSet() {
        return (MutableLongSet)this.getLongCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet without(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet with(long element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet withAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedLongSet withoutAll(LongIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableLongSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet select(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongSet reject(LongPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyLongIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyLongIterableAdapter((LongIterable)this);
        }
    }

    public MutableLongSet asUnmodifiable() {
        return new UnmodifiableLongSet(this);
    }

    public MutableLongSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableLongSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableLongSet().toImmutable();
        }
    }
}

