/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToBooleanFunction;
import com.gs.collections.api.block.function.primitive.LongToByteFunction;
import com.gs.collections.api.block.function.primitive.LongToCharFunction;
import com.gs.collections.api.block.function.primitive.LongToDoubleFunction;
import com.gs.collections.api.block.function.primitive.LongToFloatFunction;
import com.gs.collections.api.block.function.primitive.LongToIntFunction;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.block.factory.primitive.LongPredicates;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.utility.internal.primitive.LongIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyLongIterate;

import java.util.NoSuchElementException;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 *
 * @since 5.0
 */
public abstract class AbstractLazyLongIterable implements LazyLongIterable
{
    public void forEach(LongProcedure procedure)
    {
        this.each(procedure);
    }

    public int size()
    {
        return this.count(LongPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return LongIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return LongIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        LongIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(long value)
    {
        return this.anySatisfy(LongPredicates.equal(value));
    }

    public boolean containsAll(long... source)
    {
        return this.containsAll(LongSets.immutable.of(source));
    }

    public boolean containsAll(LongIterable source)
    {
        return source.allSatisfy(new LongPredicate()
        {
            public boolean accept(long value)
            {
                return AbstractLazyLongIterable.this.contains(value);
            }
        });
    }

    public LazyLongIterable select(LongPredicate predicate)
    {
        return LazyLongIterate.select(this, predicate);
    }

    public LazyLongIterable reject(LongPredicate predicate)
    {
        return LazyLongIterate.select(this, LongPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function)
    {
        return LazyLongIterate.collect(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyBooleanIterable collectBoolean(LongToBooleanFunction function)
    {
        return new CollectLongToBooleanIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyByteIterable collectByte(LongToByteFunction function)
    {
        return new CollectLongToByteIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyCharIterable collectChar(LongToCharFunction function)
    {
        return new CollectLongToCharIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyShortIterable collectShort(LongToShortFunction function)
    {
        return new CollectLongToShortIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyIntIterable collectInt(LongToIntFunction function)
    {
        return new CollectLongToIntIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyFloatIterable collectFloat(LongToFloatFunction function)
    {
        return new CollectLongToFloatIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyLongIterable collectLong(LongToLongFunction function)
    {
        return new CollectLongToLongIterable(this, function);
    }

    /**
     * @since 7.0
     */
    public LazyDoubleIterable collectDouble(LongToDoubleFunction function)
    {
        return new CollectLongToDoubleIterable(this, function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return LongIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(LongPredicate predicate)
    {
        return LongIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return LongIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return LongIterableIterate.injectInto(this, injectedValue, function);
    }

    public long[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableLongList toList()
    {
        final MutableLongList list = new LongArrayList();
        this.forEach(new LongProcedure()
        {
            public void value(long each)
            {
                list.add(each);
            }
        });
        return list;
    }

    public MutableLongSet toSet()
    {
        final MutableLongSet set = new LongHashSet();
        this.forEach(new LongProcedure()
        {
            public void value(long each)
            {
                set.add(each);
            }
        });
        return set;
    }

    public MutableLongBag toBag()
    {
        final MutableLongBag bag = new LongHashBag();
        this.forEach(new LongProcedure()
        {
            public void value(long each)
            {
                bag.add(each);
            }
        });
        return bag;
    }

    public long sum()
    {
        LongSumProcedure procedure = new LongSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long max()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        LongMaxProcedure procedure = new LongMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long maxIfEmpty(long ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.max();
    }

    public long min()
    {
        if (this.isEmpty())
        {
            throw new NoSuchElementException();
        }
        LongMinProcedure procedure = new LongMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public long minIfEmpty(long ifEmpty)
    {
        if (this.isEmpty())
        {
            return ifEmpty;
        }
        return this.min();
    }

    public double average()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        return (double) this.sum() / (double) this.size();
    }

    public double median()
    {
        if (this.isEmpty())
        {
            throw new ArithmeticException();
        }
        long[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0)
        {
            long first = sortedArray[middleIndex];
            long second = sortedArray[middleIndex - 1];
            return ((double) first + (double) second) / 2.0;
        }
        return (double) sortedArray[middleIndex];
    }

    public long[] toSortedArray()
    {
        return this.toSortedList().toArray();
    }

    public MutableLongList toSortedList()
    {
        return LongArrayList.newList(this).sortThis();
    }

    private static final class LongMaxProcedure implements LongProcedure
    {
        private boolean visitedOnce;
        private long max;

        public void value(long each)
        {
            if (this.visitedOnce)
            {
                if (this.max < each)
                {
                    this.max = each;
                }
            }
            else
            {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public long getValue()
        {
            return this.max;
        }
    }

    private static final class LongMinProcedure implements LongProcedure
    {
        private boolean visitedOnce;
        private long min;

        public void value(long each)
        {
            if (this.visitedOnce)
            {
                if (each < this.min)
                {
                    this.min = each;
                }
            }
            else
            {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public long getValue()
        {
            return this.min;
        }
    }

    private static final class LongSumProcedure implements LongProcedure
    {
        private long sum = 0;

        public void value(long each)
        {
            this.sum += each;
        }

        public long getValue()
        {
            return this.sum;
        }
    }


    public LazyLongIterable asLazy()
    {
        return this;
    }
}
