/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.util.Iterator;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToLongFunction;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.LongIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectByteToLongIterable
        extends AbstractLazyLongIterable
{
    private final ByteIterable iterable;
    private final ByteToLongFunction function;

    public CollectByteToLongIterable(ByteIterable iterable, ByteToLongFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final LongProcedure procedure)
    {
        this.iterable.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                procedure.value(CollectByteToLongIterable.this.function.valueOf(each));
            }
        });
    }

    public LongIterator longIterator()
    {
        return new LongIterator()
        {
            private final ByteIterator iterator = CollectByteToLongIterable.this.iterable.byteIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public long next()
            {
                return CollectByteToLongIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
