/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.CharIntMap;
import com.gs.collections.api.map.primitive.ImmutableCharIntMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.CharIntPair;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.iterator.ImmutableEmptyIntIterator;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyCharIterate;

/**
 * ImmutableCharIntEmptyMap is an optimization for {@link ImmutableCharIntMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableCharIntEmptyMap implements ImmutableCharIntMap, Serializable
{
    static final ImmutableCharIntMap INSTANCE = new ImmutableCharIntEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public int get(char key)
    {
        return EMPTY_VALUE;
    }

    public int getIfAbsent(char key, int ifAbsent)
    {
        return ifAbsent;
    }

    public int getOrThrow(char key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key)
    {
        return false;
    }

    public boolean containsValue(int value)
    {
        return false;
    }

    public void forEachValue(IntProcedure procedure)
    {
    }

    public void forEachKey(CharProcedure procedure)
    {
    }

    public void forEachKeyValue(CharIntProcedure procedure)
    {
    }

    public LazyCharIterable keysView()
    {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharIntPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableCharIntMap select(CharIntPredicate predicate)
    {
        return this;
    }

    public ImmutableCharIntMap reject(CharIntPredicate predicate)
    {
        return this;
    }

    public ImmutableCharIntMap toImmutable()
    {
        return this;
    }

    public IntIterator intIterator()
    {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(IntProcedure procedure)
    {
    }

    public int count(IntPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public int min()
    {
        throw new NoSuchElementException();
    }

    public int max()
    {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public int[] toSortedArray()
    {
        return new int[0];
    }

    public MutableIntList toSortedList()
    {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return true;
    }

    public ImmutableIntCollection select(IntPredicate predicate)
    {
        return IntLists.immutable.with();
    }

    public ImmutableIntCollection reject(IntPredicate predicate)
    {
        return IntLists.immutable.with();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public int[] toArray()
    {
        return new int[0];
    }

    public boolean contains(int value)
    {
        return false;
    }

    public boolean containsAll(int... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source)
    {
        return source.isEmpty();
    }

    public MutableIntList toList()
    {
        return new IntArrayList();
    }

    public MutableIntSet toSet()
    {
        return new IntHashSet();
    }

    public MutableIntBag toBag()
    {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public ImmutableCharIntMap newWithKeyValue(char key, int value)
    {
        return new ImmutableCharIntSingletonMap(key, value);
    }

    public ImmutableCharIntMap newWithoutKey(char key)
    {
        return this;
    }

    public ImmutableCharIntMap newWithoutAllKeys(CharIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableCharSet keySet()
    {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    public MutableIntCollection values()
    {
        return UnmodifiableIntCollection.of(new IntArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharIntMap))
        {
            return false;
        }
        CharIntMap map = (CharIntMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
