/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectShortProcedure;
import com.gs.collections.api.map.primitive.ObjectShortMap;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableObjectShortMap;
import com.gs.collections.api.map.primitive.MutableObjectShortMap;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.ObjectShortPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.map.mutable.primitive.ObjectShortHashMap;
import com.gs.collections.impl.set.mutable.UnmodifiableMutableSet;

/**
 * ImmutableObjectShortHashMap is the non-modifiable equivalent of {@link ObjectShortHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectShortHashMap<K> extends AbstractImmutableObjectShortMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectShortMap<K> delegate;

    ImmutableObjectShortHashMap(ObjectShortMap<? extends K> delegate)
    {
        this.delegate = new ObjectShortHashMap<K>(delegate);
    }

    public ShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(this.delegate.shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(ShortProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public short max()
    {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min()
    {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public short[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }


    public MutableShortList toSortedList()
    {
        return this.delegate.toSortedList();
    }


    public short[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(short value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.delegate.toList();
    }

    public MutableShortSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectShortMap<K> newWithKeyValue(K key, short value)
    {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectShortMap<K> newWithoutKey(K key)
    {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectShortMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectShortHashMap<K> map = ObjectShortHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public short get(Object key)
    {
        return this.delegate.get(key);
    }

    public short getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public short getIfAbsent(Object key, short ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectShortProcedure<? super K> objectShortProcedure)
    {
        this.delegate.forEachKeyValue(objectShortProcedure);
    }

    public ImmutableObjectShortMap<K> select(ObjectShortPredicate<? super K> objectShortPredicate)
    {
        return this.delegate.select(objectShortPredicate).toImmutable();
    }

    public ImmutableObjectShortMap<K> reject(ObjectShortPredicate<? super K> objectShortPredicate)
    {
        return this.delegate.reject(objectShortPredicate).toImmutable();
    }

    public ImmutableObjectShortMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectShortPair<K>> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectShortMapSerializationProxy<K>(this);
    }
}
