/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.factory.map.primitive.MutableCharObjectMapFactory;
import com.gs.collections.api.map.primitive.MutableCharObjectMap;
import com.gs.collections.api.map.primitive.CharObjectMap;

/**
 * MutableCharObjectMapFactoryImpl is a factory implementation which creates instances of type {@link MutableCharObjectMap}.
 * This file was automatically generated from template file mutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableCharObjectMapFactoryImpl implements MutableCharObjectMapFactory
{
    public <V> MutableCharObjectMap<V> empty()
    {
        return new CharObjectHashMap(0);
    }

    public <V> MutableCharObjectMap<V> of()
    {
        return this.empty();
    }

    public <V> MutableCharObjectMap<V> with()
    {
        return this.empty();
    }

    public <V> MutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> MutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new CharObjectHashMap<V>(map);
    }
}
