/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.api.stack.primitive.MutableDoubleStack;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableDoubleStack
        implements MutableDoubleStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableDoubleStack stack;

    UnmodifiableDoubleStack(MutableDoubleStack stack)
    {
        this.stack = stack;
    }

    public void push(double item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public double pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public DoubleList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public double peek()
    {
        return this.stack.peek();
    }

    public DoubleList peek(int count)
    {
        return this.stack.peek(count);
    }

    public double peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(double value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.stack.containsAll(source);
    }

    public DoubleIterator doubleIterator()
    {
        return new UnmodifiableDoubleIterator(this.stack.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(DoubleProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableDoubleStack select(DoublePredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableDoubleStack reject(DoublePredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public double sum()
    {
        return this.stack.sum();
    }

    public double max()
    {
        return this.stack.max();
    }

    public double min()
    {
        return this.stack.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableDoubleList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public double[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public double[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableDoubleList toList()
    {
        return this.stack.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public MutableDoubleStack asUnmodifiable()
    {
        return this;
    }

    public MutableDoubleStack asSynchronized()
    {
        return new SynchronizedDoubleStack(this);
    }

    public ImmutableDoubleStack toImmutable()
    {
        return DoubleStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }
}
