/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap;

import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.ImmutableMultimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractMultimap;
import com.gs.collections.impl.utility.Iterate;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImmutableMultimap<K, V, C extends ImmutableCollection<V>>
extends AbstractMultimap<K, V, C>
implements ImmutableMultimap<K, V> {
    protected final ImmutableMap<K, C> map;

    protected AbstractImmutableMultimap(MutableMap<K, C> map) {
        this(map.toImmutable());
    }

    protected AbstractImmutableMultimap(ImmutableMap<K, C> immutableMap) {
        this.map = immutableMap;
    }

    @Override
    protected ImmutableMap<K, C> getMap() {
        return this.map;
    }

    public int size() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CountProcedure
        implements Procedure<C> {
            private static final long serialVersionUID = 1L;
            private int totalSize;

            CountProcedure() {
            }

            public void value(C collection) {
                this.totalSize += collection.size();
            }

            public int getTotalSize() {
                return this.totalSize;
            }
        }
        CountProcedure procedure = new CountProcedure();
        this.map.forEachValue((Procedure)procedure);
        return procedure.getTotalSize();
    }

    public int sizeDistinct() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public C get(K key) {
        return (C)((ImmutableCollection)this.map.getIfAbsentWith(key, this.createCollectionBlock(), (Object)this));
    }

    public MutableMap<K, RichIterable<V>> toMap() {
        return this.map.toMap();
    }

    public <R extends Collection<V>> MutableMap<K, R> toMap(final Function0<R> collectionFactory) {
        final UnifiedMap result = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, C>(){

            public void value(K key, C iterable) {
                Collection newCollection = (Collection)collectionFactory.value();
                Iterate.addAllTo(iterable, newCollection);
                result.put(key, (Object)newCollection);
            }
        });
        return result;
    }

    public ImmutableMultimap<K, V> newWith(K key, V value) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.put(key, value);
        return mutableMultimap.toImmutable();
    }

    public ImmutableMultimap<K, V> newWithout(Object key, Object value) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.remove(key, value);
        return mutableMultimap.toImmutable();
    }

    public ImmutableMultimap<K, V> newWithAll(K key, Iterable<? extends V> values) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.putAll(key, values);
        return mutableMultimap.toImmutable();
    }

    public ImmutableMultimap<K, V> newWithoutAll(Object key) {
        MutableMultimap mutableMultimap = this.toMutable();
        mutableMultimap.removeAll(key);
        return mutableMultimap.toImmutable();
    }

    public ImmutableMultimap<K, V> toImmutable() {
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        throw new InvalidClassException("You should be using the proxy for serialization of ImmutableMultimaps");
    }
}

