/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.parallel;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.parallel.ArrayProcedureFJTaskRunner;
import com.gs.collections.impl.parallel.ProcedureFactory;
import com.gs.collections.impl.utility.ArrayIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayProcedureFJTask<T, BT extends Procedure<? super T>>
implements Runnable {
    private final ProcedureFactory<BT> procedureFactory;
    private BT procedure;
    private final T[] array;
    private final int start;
    private final int end;
    private final ArrayProcedureFJTaskRunner<T, BT> taskRunner;

    public ArrayProcedureFJTask(ArrayProcedureFJTaskRunner<T, BT> newFJTaskRunner, ProcedureFactory<BT> procedureFactory, T[] newArray, int newIndex, int newSectionSize, boolean isLast) {
        this.taskRunner = newFJTaskRunner;
        this.procedureFactory = procedureFactory;
        this.array = newArray;
        this.start = newIndex * newSectionSize;
        this.end = isLast ? this.array.length : this.start + newSectionSize;
    }

    @Override
    public void run() {
        try {
            this.procedure = this.procedureFactory.create();
            ArrayIterate.forEach(this.array, this.start, this.end - 1, this.procedure);
        }
        catch (Throwable newError) {
            this.taskRunner.setFailed(newError);
        }
        finally {
            this.taskRunner.taskCompleted(this);
        }
    }

    public BT getProcedure() {
        return this.procedure;
    }
}

