/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.DoubleStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedDoubleProcedure;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.UnmodifiableDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleArrayStack
implements ImmutableDoubleStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleArrayList delegate;

    private ImmutableDoubleArrayStack(double[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new DoubleArrayList(newElements);
    }

    private ImmutableDoubleArrayStack(DoubleArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use DoubleStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableDoubleArrayStack newStack(DoubleIterable iterable) {
        return new ImmutableDoubleArrayStack(iterable.toArray());
    }

    public static ImmutableDoubleArrayStack newStackWith(double ... elements) {
        double[] newArray = new double[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableDoubleArrayStack(newArray);
    }

    public static ImmutableDoubleArrayStack newStackFromTopToBottom(double ... items) {
        return new ImmutableDoubleArrayStack(DoubleArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableDoubleArrayStack newStackFromTopToBottom(DoubleIterable items) {
        return new ImmutableDoubleArrayStack(DoubleArrayList.newList(items).reverseThis());
    }

    public ImmutableDoubleStack push(double item) {
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableDoubleArrayStack(newDelegate);
    }

    public ImmutableDoubleStack pop() {
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return DoubleStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableDoubleStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return DoubleStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public double peek() {
        return this.delegate.getLast();
    }

    public DoubleList peek(int count) {
        this.checkNegativeCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new DoubleArrayList();
        }
        DoubleArrayList subList = new DoubleArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public double peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.delegate.asReversed().doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return DoubleStacks.immutable.withAllReversed((DoubleIterable)this.delegate.asReversed().select(predicate));
    }

    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return DoubleStacks.immutable.withAllReversed((DoubleIterable)this.delegate.asReversed().reject(predicate));
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public double sum() {
        return this.delegate.sum();
    }

    public double max() {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue) {
        return this.max();
    }

    public double min() {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.min();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    public double[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(double value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Double.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyDoubleIterable iterable = this.delegate.asReversed();
        DoubleIterator iterator = iterable.doubleIterator();
        while (iterator.hasNext()) {
            double item = iterator.next();
            hashCode = 31 * hashCode + (int)(Double.doubleToLongBits(item) ^ Double.doubleToLongBits(item) >>> 32);
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableDoubleStackSerializationProxy((DoubleStack)this);
    }

    private static class ImmutableDoubleStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleStack stack;

        public ImmutableDoubleStackSerializationProxy() {
        }

        protected ImmutableDoubleStackSerializationProxy(DoubleStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((DoubleProcedure)new CheckedDoubleProcedure(){

                    public void safeValue(double item) throws IOException {
                        out.writeDouble(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleArrayList deserializedDelegate = new DoubleArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readDouble());
            }
            this.stack = ImmutableDoubleArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

