/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectIntIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyIntIterate {
    private static final LazyIntIterable EMPTY_ITERABLE = IntLists.immutable.of().asLazy();

    private LazyIntIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyIntIterable adapt(IntIterable iterable) {
        return new LazyIntIterableAdapter(iterable);
    }

    public static LazyIntIterable select(IntIterable iterable, IntPredicate predicate) {
        return new SelectIntIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(IntIterable iterable, IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(IntIterable iterable, IntPredicate predicate, IntToObjectFunction<? extends V> function) {
        return LazyIntIterate.select(iterable, predicate).collect(function);
    }

    public static LazyIntIterable empty() {
        return EMPTY_ITERABLE;
    }
}

