/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.lazy.primitive.CollectLongToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectLongIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyLongIterate {
    private static final LazyLongIterable EMPTY_ITERABLE = LongLists.immutable.of().asLazy();

    private LazyLongIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyLongIterable adapt(LongIterable iterable) {
        return new LazyLongIterableAdapter(iterable);
    }

    public static LazyLongIterable select(LongIterable iterable, LongPredicate predicate) {
        return new SelectLongIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(LongIterable iterable, LongToObjectFunction<? extends V> function) {
        return new CollectLongToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(LongIterable iterable, LongPredicate predicate, LongToObjectFunction<? extends V> function) {
        return LazyLongIterate.select(iterable, predicate).collect(function);
    }

    public static LazyLongIterable empty() {
        return EMPTY_ITERABLE;
    }
}

