/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.AbstractFileTransformerMojo;
import com.gs.dmn.maven.configuration.components.DMNTransformerComponent;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.serialization.DefaultTypeDeserializationConfigurer;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.transformation.CompositeDMNTransformer;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.NopDMNTransformer;
import com.gs.dmn.transformation.lazy.CompositeLazyEvaluationDetector;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.lazy.NopLazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.CompositeDMNValidator;
import com.gs.dmn.validation.DMNValidator;
import com.gs.dmn.validation.NopDMNValidator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDMNMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST>
extends AbstractFileTransformerMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> {
    @Parameter(required=false)
    public String[] dmnValidators;
    @Parameter(required=false)
    public DMNTransformerComponent[] dmnTransformers;
    @Parameter(required=false)
    public String[] lazyEvaluationDetectors;
    @Parameter(required=false, defaultValue="com.gs.dmn.serialization.DefaultTypeDeserializationConfigurer")
    public String typeDeserializationConfigurer;
    @Parameter(required=false)
    public Map<String, String> inputParameters;

    protected DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> makeDialect(Class<?> dialectClass) throws InstantiationException, IllegalAccessException {
        try {
            return (DMNDialectDefinition)dialectClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot instantiate dialect '%s'", dialectClass == null ? null : dialectClass.getName()));
        }
    }

    protected DMNValidator makeDMNValidator(String[] dmnValidatorClassNames, BuildLogger logger) throws Exception {
        if (dmnValidatorClassNames == null) {
            return new NopDMNValidator();
        }
        ArrayList<DMNValidator> dmnValidators = new ArrayList<DMNValidator>();
        for (String dmnValidatorClassName : dmnValidatorClassNames) {
            Class<?> dmnValidatorClass = Class.forName(dmnValidatorClassName);
            try {
                dmnValidators.add((DMNValidator)dmnValidatorClass.getConstructor(BuildLogger.class).newInstance(logger));
            }
            catch (Exception e) {
                dmnValidators.add((DMNValidator)dmnValidatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        return new CompositeDMNValidator(dmnValidators);
    }

    protected DMNTransformer<TEST> makeDMNTransformer(DMNTransformerComponent[] dmnTransformerComponents, BuildLogger logger) throws Exception {
        if (dmnTransformerComponents == null) {
            return new NopDMNTransformer();
        }
        ArrayList<DMNTransformer> dmnTransformers = new ArrayList<DMNTransformer>();
        for (DMNTransformerComponent dmnTransformerComponent : dmnTransformerComponents) {
            DMNTransformer transformer;
            Class<?> dmnTransformerClass = Class.forName(dmnTransformerComponent.getName());
            try {
                transformer = (DMNTransformer)dmnTransformerClass.getConstructor(BuildLogger.class).newInstance(logger);
            }
            catch (Exception e) {
                transformer = (DMNTransformer)dmnTransformerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            transformer.configure(dmnTransformerComponent.getConfiguration());
            dmnTransformers.add(transformer);
        }
        return new CompositeDMNTransformer(dmnTransformers);
    }

    protected LazyEvaluationDetector makeLazyEvaluationDetector(String[] detectorClassNames, BuildLogger logger, InputParameters inputParameters) throws Exception {
        if (detectorClassNames == null) {
            return new NopLazyEvaluationDetector();
        }
        ArrayList<LazyEvaluationDetector> detectors = new ArrayList<LazyEvaluationDetector>();
        for (String detectorClassName : detectorClassNames) {
            Class<?> detectorClass = Class.forName(detectorClassName);
            try {
                detectors.add((LazyEvaluationDetector)detectorClass.getConstructor(InputParameters.class, BuildLogger.class).newInstance(inputParameters, logger));
            }
            catch (Exception e) {
                detectors.add((LazyEvaluationDetector)detectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        return new CompositeLazyEvaluationDetector(detectors);
    }

    protected TypeDeserializationConfigurer makeTypeDeserializationConfigurer(String deserializerClassName, BuildLogger logger) throws Exception {
        if (deserializerClassName == null) {
            return new DefaultTypeDeserializationConfigurer();
        }
        Class<?> deserializerClass = Class.forName(deserializerClassName);
        try {
            return (TypeDeserializationConfigurer)deserializerClass.getConstructor(BuildLogger.class).newInstance(logger);
        }
        catch (Exception ex) {
            return (TypeDeserializationConfigurer)deserializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    protected TemplateProvider makeTemplateProvider(String templateProviderClassName, BuildLogger logger) throws Exception {
        Class<?> templateProviderClass = Class.forName(templateProviderClassName);
        try {
            return (TemplateProvider)templateProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot build template provider '%s'", templateProviderClass));
        }
    }

    @Override
    protected InputParameters makeInputParameters() {
        return new InputParameters(this.inputParameters);
    }
}

