/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.AbstractDMNMojo;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.transformation.DMNToNativeTransformer;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.FileTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.DMNValidator;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractDMNToNativeMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST>
extends AbstractDMNMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> {
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/dmn")
    public File inputFileDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/dmn")
    public File outputFileDirectory;

    public void execute() throws MojoExecutionException {
        this.transform(this.inputFileDirectory, this.outputFileDirectory);
    }

    protected void checkMandatoryFields(String dmnDialect) {
        this.checkMandatoryField(this.project, "project");
        this.checkMandatoryField(this.inputFileDirectory, "inputFileDirectory");
        this.checkMandatoryField(this.outputFileDirectory, "outputFileDirectory");
        this.checkMandatoryField(dmnDialect, "dmnDialect");
    }

    protected FileTransformer makeTransformer(BuildLogger logger, String dmnDialectName, String templateProviderName) throws Exception {
        Class<?> dialectClass = Class.forName(dmnDialectName);
        DMNDialectDefinition dmnDialect = this.makeDialect(dialectClass);
        DMNValidator dmnValidator = this.makeDMNValidator(this.dmnValidators, logger);
        DMNTransformer dmnTransformer = this.makeDMNTransformer(this.dmnTransformers, logger);
        TemplateProvider templateProvider = this.makeTemplateProvider(templateProviderName, logger);
        InputParameters inputParameters = this.makeInputParameters();
        LazyEvaluationDetector lazyEvaluationDetector = this.makeLazyEvaluationDetector(this.lazyEvaluationDetectors, logger, inputParameters);
        TypeDeserializationConfigurer typeDeserializationConfigurer = this.makeTypeDeserializationConfigurer(this.typeDeserializationConfigurer, logger);
        this.validateParameters(dmnDialect, dmnValidator, dmnTransformer, templateProvider, inputParameters);
        DMNToNativeTransformer transformer = dmnDialect.createDMNToNativeTransformer(dmnValidator, dmnTransformer, templateProvider, lazyEvaluationDetector, typeDeserializationConfigurer, inputParameters, logger);
        return transformer;
    }

    @Override
    protected void addSourceRoot(File outputFileDirectory) throws IOException {
        this.project.addCompileSourceRoot(outputFileDirectory.getCanonicalPath());
    }

    private void validateParameters(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> dmnDialect, DMNValidator dmnValidator, DMNTransformer<TEST> dmnTransformer, TemplateProvider templateProvider, InputParameters inputParameters) {
        boolean onePackage = inputParameters.isOnePackage();
        boolean singletonInputData = inputParameters.isSingletonInputData();
        boolean caching = inputParameters.isCaching();
        if (onePackage) {
            this.getLog().warn((CharSequence)"Use 'onePackage' carefully, names must be unique across all the DMs.");
        }
        if (!singletonInputData && caching) {
            this.getLog().error((CharSequence)String.format("Incompatible 'singletonInputData=%s' and 'caching=%s'", singletonInputData, caching));
        }
    }
}

