/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.MavenBuildLogger;
import com.gs.dmn.transformation.FileTransformer;
import com.gs.dmn.transformation.InputParameters;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractFileTransformerMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST>
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;

    protected void transform(File inputFileDirectory, File outputFileDirectory) throws MojoExecutionException {
        this.checkMandatoryFields();
        try {
            FileTransformer transformer = this.makeTransformer(new MavenBuildLogger(this.getLog()));
            this.getLog().info((CharSequence)String.format("Transforming '%s' to '%s' ...", inputFileDirectory, outputFileDirectory));
            transformer.transform(inputFileDirectory.toPath(), outputFileDirectory.toPath());
            this.addSourceRoot(outputFileDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    protected void checkMandatoryField(Object fieldValue, String fieldName) {
        if (fieldValue == null) {
            throw new IllegalArgumentException(String.format("'%s' is mandatory.", fieldName));
        }
    }

    protected abstract void addSourceRoot(File var1) throws IOException;

    protected abstract FileTransformer makeTransformer(BuildLogger var1) throws Exception;

    protected abstract InputParameters makeInputParameters();

    protected abstract void checkMandatoryFields();
}

