/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.AbstractDMNMojo;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.FileTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.DMNValidator;
import java.io.File;
import java.io.IOException;

public abstract class AbstractTestToJunitMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST>
extends AbstractDMNMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> {
    @Override
    protected void addSourceRoot(File outputFileDirectory) throws IOException {
        this.project.addTestCompileSourceRoot(outputFileDirectory.getCanonicalPath());
    }

    protected FileTransformer makeTransformer(BuildLogger logger, String dmnDialectName, String templateProviderName) throws Exception {
        Class<?> dialectClass = Class.forName(dmnDialectName);
        DMNDialectDefinition dmnDialect = this.makeDialect(dialectClass);
        DMNValidator dmnValidator = this.makeDMNValidator(this.dmnValidators, logger);
        DMNTransformer dmnTransformer = this.makeDMNTransformer(this.dmnTransformers, logger);
        TemplateProvider templateProvider = this.makeTemplateProvider(templateProviderName, logger);
        InputParameters inputParameters = this.makeInputParameters();
        LazyEvaluationDetector lazyEvaluationDetector = this.makeLazyEvaluationDetector(this.lazyEvaluationDetectors, logger, inputParameters);
        TypeDeserializationConfigurer typeDeserializationConfigurer = this.makeTypeDeserializationConfigurer(this.typeDeserializationConfigurer, logger);
        this.validateParameters(dmnDialect, dmnValidator, dmnTransformer, templateProvider, inputParameters);
        FileTransformer transformer = this.makeTransformer(dmnDialect, dmnValidator, dmnTransformer, templateProvider, lazyEvaluationDetector, typeDeserializationConfigurer, inputParameters, logger);
        return transformer;
    }

    private void validateParameters(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> dmnDialect, DMNValidator dmnValidator, DMNTransformer<TEST> dmnTransformer, TemplateProvider templateProvider, InputParameters inputParameters) {
        boolean onePackage = inputParameters.isOnePackage();
        boolean singletonInputData = inputParameters.isSingletonInputData();
        boolean caching = inputParameters.isCaching();
        if (onePackage) {
            this.getLog().warn((CharSequence)"Use 'onePackage' carefully, names must be unique across all the DMs.");
        }
        if (!singletonInputData && caching) {
            this.getLog().error((CharSequence)String.format("Incompatible 'singletonInputData=%s' and 'caching=%s'", singletonInputData, caching));
        }
    }

    protected abstract FileTransformer makeTransformer(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> var1, DMNValidator var2, DMNTransformer<TEST> var3, TemplateProvider var4, LazyEvaluationDetector var5, TypeDeserializationConfigurer var6, InputParameters var7, BuildLogger var8);
}

