/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.AbstractFileTransformerMojo;
import com.gs.dmn.signavio.rdf2dmn.RDFToDMNTransformer;
import com.gs.dmn.transformation.FileTransformer;
import com.gs.dmn.transformation.InputParameters;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="rdf-to-dmn", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RDFToDMNMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST>
extends AbstractFileTransformerMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TEST> {
    @Parameter(required=false)
    public Map<String, String> inputParameters;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/signavio")
    public File inputFileDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-resources/dmn")
    public File outputFileDirectory;

    public void execute() throws MojoExecutionException {
        this.transform(this.inputFileDirectory, this.outputFileDirectory);
    }

    @Override
    protected void checkMandatoryFields() {
        this.checkMandatoryField(this.inputFileDirectory, "inputFileDirectory");
        this.checkMandatoryField(this.outputFileDirectory, "outputFileDirectory");
    }

    @Override
    protected FileTransformer makeTransformer(BuildLogger logger) {
        RDFToDMNTransformer transformer = new RDFToDMNTransformer(this.makeInputParameters(), logger);
        return transformer;
    }

    @Override
    protected InputParameters makeInputParameters() {
        return new InputParameters(this.inputParameters);
    }

    @Override
    protected void addSourceRoot(File outputFileDirectory) throws IOException {
        this.project.addCompileSourceRoot(outputFileDirectory.getCanonicalPath());
    }
}

