/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.maven;

import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.maven.AbstractTestToJunitMojo;
import com.gs.dmn.serialization.TypeDeserializationConfigurer;
import com.gs.dmn.tck.TCKTestCasesToKotlinJUnitTransformer;
import com.gs.dmn.tck.ast.TestCases;
import com.gs.dmn.transformation.DMNTransformer;
import com.gs.dmn.transformation.FileTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.template.TemplateProvider;
import com.gs.dmn.validation.DMNValidator;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="tck-to-kotlin", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, configurator="dmn-mojo-configurator")
public class TCKToKotlinJUnitMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION>
extends AbstractTestToJunitMojo<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestCases> {
    @Parameter(required=true, defaultValue="com.gs.dmn.dialect.KotlinStandardDMNDialectDefinition")
    public String dmnDialect;
    @Parameter(required=true, defaultValue="com.gs.dmn.transformation.template.KotlinTreeTemplateProvider")
    public String templateProvider;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/tck")
    public File inputTestFileDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/tck")
    public File inputModelFileDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-test-sources/junit")
    public File outputFileDirectory;

    public void execute() throws MojoExecutionException {
        this.transform(this.inputTestFileDirectory, this.outputFileDirectory);
    }

    @Override
    protected void checkMandatoryFields() {
        this.checkMandatoryField(this.inputTestFileDirectory, "inputTestFileDirectory");
        this.checkMandatoryField(this.inputModelFileDirectory, "inputModelFileDirectory");
        this.checkMandatoryField(this.outputFileDirectory, "outputFileDirectory");
        this.checkMandatoryField(this.dmnDialect, "dmnDialect");
    }

    @Override
    protected FileTransformer makeTransformer(BuildLogger logger) throws Exception {
        return super.makeTransformer(logger, this.dmnDialect, this.templateProvider);
    }

    @Override
    protected FileTransformer makeTransformer(DMNDialectDefinition<NUMBER, DATE, TIME, DATE_TIME, DURATION, TestCases> dmnDialect, DMNValidator dmnValidator, DMNTransformer<TestCases> dmnTransformer, TemplateProvider templateProvider, LazyEvaluationDetector lazyEvaluationDetector, TypeDeserializationConfigurer typeDeserializationConfigurer, InputParameters inputParameters, BuildLogger logger) {
        return new TCKTestCasesToKotlinJUnitTransformer(dmnDialect, dmnValidator, dmnTransformer, templateProvider, lazyEvaluationDetector, typeDeserializationConfigurer, this.inputModelFileDirectory.toPath(), this.makeInputParameters(), logger);
    }
}

