/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio;

import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.DRGElementReference;
import com.gs.dmn.ImportPath;
import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDMNElementReference;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionService;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.serialization.DMNVersion;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.extension.SignavioExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;

public class SignavioDMNModelRepository
extends DMNModelRepository {
    private String schemaNamespace = "http://www.signavio.com/schema/dmn/1.1/";
    private final String[] schemaPrefixes = new String[]{"signavio", "sigExt", ""};
    private QName diagramIdQName = new QName(this.schemaNamespace, "diagramId");
    private QName shapeIdQName = new QName(this.schemaNamespace, "shapeId");
    public final SignavioExtension extension = new SignavioExtension(this);
    private final Map<String, TDRGElement> cache = new LinkedHashMap<String, TDRGElement>();
    private final Set<TInputData> iterators = new LinkedHashSet<TInputData>();

    public SignavioDMNModelRepository() {
        this(OBJECT_FACTORY.createTDefinitions());
    }

    public SignavioDMNModelRepository(TDefinitions definitions) {
        this(Collections.singletonList(definitions));
    }

    public SignavioDMNModelRepository(List<TDefinitions> definitionsList) {
        super(definitionsList);
        this.populateSignavioCaches(definitionsList);
    }

    public SignavioDMNModelRepository(TDefinitions definitions, String schemaNamespace) {
        this(Collections.singletonList(definitions), schemaNamespace);
    }

    public SignavioDMNModelRepository(List<TDefinitions> definitionsList, String schemaNamespace) {
        super(definitionsList);
        this.schemaNamespace = schemaNamespace;
        this.diagramIdQName = new QName(schemaNamespace, "diagramId");
        this.shapeIdQName = new QName(schemaNamespace, "shapeId");
        this.populateSignavioCaches(definitionsList);
    }

    private void populateSignavioCaches(List<TDefinitions> definitionsList) {
        for (TDefinitions definitions : definitionsList) {
            List<Object> elementList = this.extension.findExtensions(definitions.getExtensionElements(), DMNVersion.LATEST.getNamespace(), "decisionService");
            for (Object element : elementList) {
                if (!(element instanceof TDecisionService)) continue;
                this.addElementMap((TDRGElement)((TDecisionService)element), definitions);
            }
            for (Object element : this.findDecisions(definitions)) {
                if (!this.isMultiInstanceDecision((TDRGElement)element)) continue;
                MultiInstanceDecisionLogic midLogic = this.extension.multiInstanceDecisionLogic((TDRGElement)element);
                this.iterators.add((TInputData)midLogic.getIterator());
            }
        }
    }

    protected void addModelCoordinates(TDefinitions definitions, TDMNElement element, List<String> locationParts) {
        String diagramId = this.getDiagramId(element);
        if (!StringUtils.isBlank((CharSequence)diagramId)) {
            locationParts.add(String.format("model='%s'", diagramId));
        } else {
            String modelName = definitions.getName();
            if (!StringUtils.isBlank((CharSequence)modelName)) {
                locationParts.add(String.format("model='%s'", modelName));
            }
        }
    }

    public SignavioDMNModelRepository copy() {
        return new SignavioDMNModelRepository(this.definitionsList, this.schemaNamespace);
    }

    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public String[] getSchemaPrefixes() {
        return this.schemaPrefixes;
    }

    private QName getDiagramIdQName() {
        return this.diagramIdQName;
    }

    private QName getShapeIdQName() {
        return this.shapeIdQName;
    }

    public String getDiagramId(TDMNElement element) {
        if (element == null) {
            return null;
        }
        Map otherAttributes = element.getOtherAttributes();
        QName diagramIdQName = this.getDiagramIdQName();
        return otherAttributes == null ? null : (String)otherAttributes.get(diagramIdQName);
    }

    public String getShapeId(TDRGElement element) {
        if (element == null) {
            return null;
        }
        Map otherAttributes = element.getOtherAttributes();
        QName shapeIdQName = this.getShapeIdQName();
        return otherAttributes == null ? null : (String)otherAttributes.get(shapeIdQName);
    }

    public SignavioExtension getExtension() {
        return this.extension;
    }

    public boolean isBKMLinkedToDecision(TNamedElement element) {
        return element instanceof TBusinessKnowledgeModel && this.getOutputDecision((TBusinessKnowledgeModel)element) != null;
    }

    public TDecision getOutputDecision(TBusinessKnowledgeModel element) {
        TDecisionService decisionService = this.getExtension().referencedService(element);
        return decisionService == null ? null : this.getOutputDecision(decisionService);
    }

    public boolean isMultiInstanceDecision(TDRGElement decision) {
        return this.extension.isMultiInstanceDecision(decision);
    }

    public boolean isIterator(TInputData inputData) {
        return this.iterators.contains(inputData);
    }

    protected List<DRGElementReference<TInputData>> collectTransitiveInputDatas(DRGElementReference<? extends TDRGElement> parentReference) {
        TDRGElement parent = parentReference.getElement();
        ImportPath parentImportPath = parentReference.getImportPath();
        ArrayList<DRGElementReference<TInputData>> result = new ArrayList<DRGElementReference<TInputData>>();
        result.addAll(this.directInputDatas(parent));
        if (this.isMultiInstanceDecision(parent)) {
            MultiInstanceDecisionLogic multiInstanceDecisionLogic = this.extension.multiInstanceDecisionLogic(parent);
            TDecision topLevelDecision = multiInstanceDecisionLogic.getTopLevelDecision();
            DRGElementReference topLevelReference = this.makeDRGElementReference((TDRGElement)topLevelDecision);
            List<DRGElementReference<TInputData>> inputDataList = this.collectTransitiveInputDatas((DRGElementReference<? extends TDRGElement>)topLevelReference);
            inputDataList.removeIf(tInputDataDMNReference -> tInputDataDMNReference.getElement() == multiInstanceDecisionLogic.getIterator());
            result.addAll(inputDataList);
        }
        List childReferences = this.requiredDecisionReferences(parent);
        for (TDMNElementReference reference : childReferences) {
            TDecision child = this.findDecisionByRef(parent, reference.getHref());
            if (child != null) {
                String importName = this.findImportName(parent, reference);
                DRGElementReference childReference = this.makeDRGElementReference(new ImportPath(parentImportPath, importName), (TDRGElement)child);
                List<DRGElementReference<TInputData>> inputReferences = this.collectTransitiveInputDatas((DRGElementReference<? extends TDRGElement>)childReference);
                result.addAll(inputReferences);
                continue;
            }
            throw new DMNRuntimeException(String.format("Cannot find Decision for '%s' in parent '%s'", reference.getHref(), parent.getName()));
        }
        return result;
    }

    public void addItemDefinition(TDefinitions definitions, TItemDefinition itemDefinition) {
        definitions.getItemDefinition().add(itemDefinition);
        this.itemDefinitions.add(itemDefinition);
    }

    public TDRGElement findDRGElementById(String id) {
        String key = this.makeKey(id);
        TDRGElement result = this.cache.get(key);
        if (result == null) {
            TDefinitions definitions = this.getRootDefinitions();
            List drgElements = this.findDRGElements(definitions);
            for (TDRGElement element : drgElements) {
                if (!this.sameId((TNamedElement)element, id)) continue;
                result = element;
                this.cache.put(key, result);
                break;
            }
        }
        return result;
    }

    public TDRGElement findDRGElementByDiagramAndShapeIds(String diagramId, String shapeId) {
        String key = this.makeKey(diagramId, shapeId);
        TDRGElement result = this.cache.get(key);
        if (result == null) {
            TDefinitions definitions = this.getRootDefinitions();
            List drgElements = this.findDRGElements(definitions);
            for (TDRGElement element : drgElements) {
                if (!this.idEndsWith((TNamedElement)element, shapeId) && (!this.sameDiagramId(element, diagramId) || !this.sameShapeId(element, shapeId))) continue;
                result = element;
                this.cache.put(key, result);
                break;
            }
        }
        return result;
    }

    public TDRGElement findDRGElementByLabel(String label, String diagramId, String shapeId) {
        String key = this.makeKey(label, diagramId, shapeId);
        TDRGElement result = this.cache.get(key);
        if (result == null) {
            TDefinitions definitions = this.getRootDefinitions();
            List drgElements = this.findDRGElements(definitions);
            List elements = drgElements.stream().filter(element -> this.sameLabel((TNamedElement)element, label)).collect(Collectors.toList());
            if (elements.size() == 0) {
                result = null;
            } else if (elements.size() == 1) {
                result = (TDRGElement)elements.get(0);
            } else {
                List sameShapeIdElements = elements.stream().filter(e -> this.sameShapeId((TDRGElement)e, shapeId)).collect(Collectors.toList());
                QName diagramQName = this.getDiagramIdQName();
                String newDiagramID = elements.stream().filter(e -> this.sameShapeId((TDRGElement)e, shapeId)).map(e -> (String)e.getOtherAttributes().get(diagramQName)).collect(Collectors.joining(", "));
                if (sameShapeIdElements.size() == 1) {
                    LOGGER.warn(String.format("Incorrect diagramId for test input with label '%s' diagramId='%s' shapeId='%s'. DiagramId should be '%s'", label, diagramId, shapeId, newDiagramID));
                    result = (TDRGElement)sameShapeIdElements.get(0);
                } else {
                    throw new DMNRuntimeException(String.format("Multiple DRGElements for label '%s' with diagramId='%s' shapeId='%s'. Diagram ID should be one of '%s'", label, diagramId, shapeId, newDiagramID));
                }
            }
            if (result != null) {
                this.cache.put(key, result);
            }
        }
        return result;
    }

    public boolean idEndsWith(TNamedElement element, String id) {
        return id != null && element.getId().endsWith(id);
    }

    private boolean sameId(TNamedElement element, String id) {
        return id != null && id.equals(element.getId());
    }

    private boolean sameDiagramId(TDRGElement element, String id) {
        if (id == null) {
            return false;
        }
        Map otherAttributes = element.getOtherAttributes();
        QName diagramIdQName = this.getDiagramIdQName();
        String diagramId = (String)otherAttributes.get(diagramIdQName);
        return id.equals(diagramId);
    }

    private boolean sameShapeId(TDRGElement element, String id) {
        if (id == null) {
            return false;
        }
        Map otherAttributes = element.getOtherAttributes();
        QName shapeIdQName = this.getShapeIdQName();
        String shapeId = (String)otherAttributes.get(shapeIdQName);
        return id.equals(shapeId);
    }

    public boolean sameLabel(TNamedElement element, String label) {
        return label != null && label.equals(element.getLabel());
    }

    private String makeKey(String id) {
        return String.format("%s::", id);
    }

    private String makeKey(String diagramId, String shapeId) {
        return String.format("%s:%s:", diagramId, shapeId);
    }

    private String makeKey(String label, String diagramId, String shapeId) {
        return String.format("%s:%s:%s", label, diagramId, shapeId);
    }
}

