/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.extension;

import com.gs.dmn.ast.TBusinessKnowledgeModel;
import com.gs.dmn.ast.TDMNElement;
import com.gs.dmn.ast.TDRGElement;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionService;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.runtime.metadata.ExtensionElement;
import com.gs.dmn.runtime.metadata.MultiInstanceDecisionLogicExtension;
import com.gs.dmn.serialization.DMNVersion;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.extension.Aggregator;
import com.gs.dmn.signavio.extension.MultiInstanceDecisionLogic;
import com.gs.dmn.signavio.serialization.xstream.ReferencedService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SignavioExtension {
    public static final String SIG_EXT_NAMESPACE = "http://www.signavio.com/schema/dmn/1.1/";
    private final SignavioDMNModelRepository dmnModelRepository;

    public SignavioExtension(SignavioDMNModelRepository dmnModelRepository) {
        this.dmnModelRepository = dmnModelRepository;
    }

    public TDecisionService referencedService(TBusinessKnowledgeModel bkm) {
        TDMNElement.ExtensionElements extensionElements = bkm.getExtensionElements();
        List<Object> extensions = this.findExtensions(extensionElements, this.dmnModelRepository.getSchemaNamespace(), "referencedService");
        if (extensions.isEmpty()) {
            return null;
        }
        Object extension = extensions.get(0);
        if (extension instanceof ReferencedService) {
            ReferencedService referencedService = (ReferencedService)extension;
            String serviceId = referencedService.getHref();
            TDefinitions definitions = this.dmnModelRepository.getRootDefinitions();
            return this.decisionService(definitions, serviceId);
        }
        String serviceId = this.getAttributeByName((Element)extension, "href");
        TDefinitions definitions = this.dmnModelRepository.getRootDefinitions();
        return this.decisionService(definitions, serviceId);
    }

    private TDecisionService decisionService(TDefinitions definitions, String serviceId) {
        List<Object> elementList = this.findExtensions(definitions.getExtensionElements(), DMNVersion.LATEST.getNamespace(), "decisionService");
        for (Object element : elementList) {
            if (!(element instanceof TDecisionService) || !this.dmnModelRepository.sameId((TDMNElement)((TNamedElement)element), serviceId)) continue;
            return (TDecisionService)element;
        }
        throw new DMNRuntimeException(String.format("Cannot find Decision service '%s'", serviceId));
    }

    private boolean hasName(Object extension, String namespace, String tagName) {
        if (extension instanceof Element) {
            Element element = (Element)extension;
            String namespaceURI = element.getNamespaceURI();
            String name = element.getLocalName();
            return tagName.equals(name) && namespace.equals(namespaceURI);
        }
        if (extension instanceof TDecisionService) {
            return tagName.equals("decisionService");
        }
        if (extension instanceof ReferencedService) {
            return tagName.equals("referencedService");
        }
        if (extension instanceof com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic) {
            return tagName.equals("MultiInstanceDecisionLogic");
        }
        return false;
    }

    public boolean isMultiInstanceDecision(TDRGElement element) {
        try {
            List<Object> extensions = this.findExtensions(element.getExtensionElements(), this.dmnModelRepository.getSchemaNamespace(), "MultiInstanceDecisionLogic");
            return extensions != null && extensions.size() == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public MultiInstanceDecisionLogic multiInstanceDecisionLogic(TDRGElement element) {
        String topLevelDecisionId;
        String aggregationFunction;
        String iteratorShapeId;
        String iterationExpression;
        Object decisionElement;
        List<Object> extensions = this.findExtensions(element.getExtensionElements(), this.dmnModelRepository.getSchemaNamespace(), "MultiInstanceDecisionLogic");
        Object extension = extensions.get(0);
        if (extension instanceof com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic) {
            decisionElement = (com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic)extension;
            iterationExpression = ((com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic)decisionElement).getIterationExpression();
            iteratorShapeId = ((com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic)decisionElement).getIteratorShapeId();
            aggregationFunction = ((com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic)decisionElement).getAggregationFunction();
            topLevelDecisionId = ((com.gs.dmn.signavio.serialization.xstream.MultiInstanceDecisionLogic)decisionElement).getTopLevelDecisionId();
        } else {
            decisionElement = (Element)extension;
            iterationExpression = this.getElementsByTagName((Element)decisionElement, "iterationExpression").item(0).getTextContent();
            iteratorShapeId = this.getElementsByTagName((Element)decisionElement, "iteratorShapeId").item(0).getTextContent();
            aggregationFunction = this.getElementsByTagName((Element)decisionElement, "aggregationFunction").item(0).getTextContent();
            topLevelDecisionId = this.getElementsByTagName((Element)decisionElement, "topLevelDecisionId").item(0).getTextContent();
        }
        TDRGElement iterator = this.findDRGElementByPartialId(iteratorShapeId);
        Aggregator aggregator = Aggregator.valueOf(aggregationFunction);
        TDRGElement topLevelDecision = this.findDRGElementByPartialId(topLevelDecisionId);
        return new MultiInstanceDecisionLogic(iterationExpression, iterator, aggregator, (TDecision)topLevelDecision);
    }

    public ExtensionElement makeMultiInstanceExtension(TDecision decision) {
        MultiInstanceDecisionLogic multiInstanceDecisionLogic = this.multiInstanceDecisionLogic((TDRGElement)decision);
        String topLevelDecisionId = multiInstanceDecisionLogic.getTopLevelDecision().getId();
        String aggregator = multiInstanceDecisionLogic.getAggregator().name();
        String iteratorId = multiInstanceDecisionLogic.getIterator().getId();
        String iterationExpression = multiInstanceDecisionLogic.getIterationExpression();
        return new MultiInstanceDecisionLogicExtension(iterationExpression, iteratorId, aggregator, topLevelDecisionId);
    }

    private TDRGElement findDRGElementByPartialId(String iteratorShapeId) {
        String suffix = iteratorShapeId.substring(3);
        for (TDefinitions definitions : this.dmnModelRepository.getAllDefinitions()) {
            for (TDRGElement element : this.dmnModelRepository.findDRGElements(definitions)) {
                if (!element.getId().endsWith(suffix)) continue;
                return element;
            }
        }
        return null;
    }

    public List<Object> findExtensions(TDMNElement.ExtensionElements extensionElements, String namespace, String extensionName) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        if (extensionElements != null && extensionElements.getAny() != null && !extensionElements.getAny().isEmpty()) {
            List any = extensionElements.getAny();
            for (Object extension : any) {
                if (!this.hasName(extension, namespace, extensionName)) continue;
                extensions.add(extension);
            }
        }
        return extensions;
    }

    private String getAttributeByName(Element element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        if (StringUtils.isNotEmpty((CharSequence)attribute)) {
            return attribute;
        }
        throw new IllegalArgumentException(String.format("Cannot find attribute name extension '%s'", attributeName));
    }

    private NodeList getElementsByTagName(Element element, String tagName) {
        for (String prefix : this.dmnModelRepository.getSchemaPrefixes()) {
            String qTagName = "".equals(prefix) ? tagName : String.format("%s:%s", prefix, tagName);
            NodeList nodeList = element.getElementsByTagName(qTagName);
            if (nodeList.getLength() != 1) continue;
            return nodeList;
        }
        throw new IllegalArgumentException(String.format("Cannot find Signavio extension '%s'", tagName));
    }
}

