/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.rdf2dmn;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gs.dmn.feel.analysis.semantics.type.FEELTypes;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.signavio.rdf2dmn.json.EnumItem;
import com.gs.dmn.signavio.rdf2dmn.json.ItemDefinition;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionExpression;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionTable;
import com.gs.dmn.signavio.rdf2dmn.json.decision.OutputClause;
import com.gs.dmn.signavio.rdf2dmn.json.relation.Relation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RDFModel {
    public static final String INPUT_DATA = "InputData";
    public static final String DECISION = "Decision";
    public static final String INFORMATION_REQUIREMENT = "InformationRequirement";
    private static final String ORYX_NS = "http://oryx-editor.org/";
    private static final String RAZEL_NS = "http://raziel.org/";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private final Document model;

    public RDFModel(Document model) {
        this.model = model;
    }

    public String getAboutAttribute(Element resource) {
        return resource.getAttribute("rdf:about").replace("#", "");
    }

    public String getResourceAttribute(Element resource) {
        return resource.getAttribute("rdf:resource").replace("#", "");
    }

    public String getName(Element resource) {
        return this.getObject(resource, "name");
    }

    public String getLabel(Element resource) {
        return this.getObject(resource, "name");
    }

    public String getEnumItems(Element resource) {
        return this.getObject(resource, "enumitems");
    }

    public String getDecision(Element resource) {
        return this.getObject(resource, "decision");
    }

    public String getRelations(Element resource) {
        return this.getObject(resource, "relations");
    }

    public List<Relation> getRelationList(String relationsString) {
        try {
            return (List)MAPPER.readValue(relationsString, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, Relation.class));
        }
        catch (IOException e) {
            throw new DMNRuntimeException(String.format("Cannot deserialize relations '%s'", relationsString), (Throwable)e);
        }
    }

    public List<EnumItem> getEnumItemList(String enumItemsString) {
        try {
            return (List)MAPPER.readValue(enumItemsString, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, EnumItem.class));
        }
        catch (IOException e) {
            throw new DMNRuntimeException(String.format("Cannot deserialize enumItems '%s'", enumItemsString), (Throwable)e);
        }
    }

    public String getObject(Element resource, String propertyName) {
        NodeList elementsByTagName = resource.getElementsByTagName(propertyName);
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node item = elementsByTagName.item(i);
            String textContent = item.getTextContent();
            if (StringUtils.isBlank((CharSequence)textContent)) continue;
            return textContent;
        }
        return null;
    }

    public boolean isDecision(Element resource) {
        return this.isElementType(resource, DECISION);
    }

    public boolean isInputData(Element resource) {
        return this.isElementType(resource, INPUT_DATA);
    }

    public List<Element> findAllInformationRequirement() {
        return this.findAll(INFORMATION_REQUIREMENT);
    }

    private List<Element> findAll(String type) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList descriptions = this.model.getDocumentElement().getElementsByTagName("rdf:Description");
        for (int i = 0; i < descriptions.getLength(); ++i) {
            Node description = descriptions.item(i);
            NodeList properties = description.getChildNodes();
            for (int j = 0; j < properties.getLength(); ++j) {
                String nodeValue;
                String nodeName;
                Node tag = properties.item(j);
                if (tag == null || !"type".equalsIgnoreCase(nodeName = tag.getNodeName()) || !type.equals(nodeValue = tag.getTextContent())) continue;
                result.add((Element)description);
            }
        }
        return result;
    }

    public List<Element> findAllDecision() {
        return this.findAll(DECISION);
    }

    public List<Element> findAllInputData() {
        return this.findAll(INPUT_DATA);
    }

    public Element findDecisionById(String shapeId) {
        List<Element> allInputData = this.findAllDecision();
        for (Element element : allInputData) {
            if (!this.getAboutAttribute(element).equals(shapeId)) continue;
            return element;
        }
        return null;
    }

    public Element findInputDataById(String shapeId) {
        List<Element> allInputData = this.findAllInputData();
        for (Element element : allInputData) {
            if (!this.getAboutAttribute(element).equals(shapeId)) continue;
            return element;
        }
        return null;
    }

    private boolean isElementType(Element resource, String type) {
        NodeList children = resource.getElementsByTagName("type");
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String textContent = child.getTextContent();
            if (!type.equals(textContent)) continue;
            return true;
        }
        return false;
    }

    public String getFEELType(Element resource) {
        List<String> types = this.getTypes(resource);
        List foundTypes = types.stream().filter(FEELTypes.FEEL_TYPE_NAMES::contains).collect(Collectors.toList());
        return foundTypes.size() == 1 ? (String)foundTypes.get(0) : null;
    }

    private List<String> getTypes(Element resource) {
        ArrayList<String> types = new ArrayList<String>();
        NodeList children = resource.getElementsByTagName("type");
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String textContent = child.getTextContent();
            types.add(textContent);
        }
        return types;
    }

    public List<Element> findAllObjects(Element decision, String propertyName) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        NodeList nodeList = decision.getElementsByTagName(propertyName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.add((Element)nodeList.item(i));
        }
        return nodes;
    }

    public String pathName(Element element, String outputId) {
        try {
            if (this.isDecision(element)) {
                String decisionText = this.getDecision(element);
                DecisionExpression expression = (DecisionExpression)MAPPER.readValue(decisionText, DecisionExpression.class);
                if (expression instanceof DecisionTable) {
                    for (OutputClause oc : ((DecisionTable)expression).getOutputClauses()) {
                        ItemDefinition itemDefinition = oc.getItemDefinition();
                        if (!outputId.equals(oc.getId())) continue;
                        return itemDefinition.getName();
                    }
                }
            } else if (this.isInputData(element)) {
                String relationsText = this.getRelations(element);
                List relations = (List)MAPPER.readValue(relationsText, (TypeReference)new TypeReference<List<Relation>>(){});
                for (Relation relation : relations) {
                    if (!relation.getValue().getPathElements().contains(Integer.valueOf(outputId))) continue;
                    return relation.getValue().getName();
                }
            }
            throw new DMNRuntimeException(String.format("Cannot find output '%s' in element '%s'", outputId, element.getAttribute("id")));
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot find output '%s' in element '%s'", outputId, element.getAttribute("id")), (Throwable)e);
        }
    }

    boolean isList(Element resource) {
        return Boolean.parseBoolean(this.getObject(resource, "islist"));
    }

    public Element findDescriptionById(String resourceId) {
        if (!resourceId.startsWith("#")) {
            resourceId = "#" + resourceId;
        }
        NodeList descriptions = this.model.getDocumentElement().getElementsByTagName("rdf:Description");
        for (int i = 0; i < descriptions.getLength(); ++i) {
            Node description = descriptions.item(i);
            Node about = description.getAttributes().getNamedItem("rdf:about");
            if (!resourceId.equals(about.getNodeValue())) continue;
            return (Element)description;
        }
        return null;
    }

    public boolean hasSingleOutput(String decisionId) {
        try {
            List<OutputClause> outputClauses;
            Element decision = this.findDecisionById(decisionId);
            String decisionText = this.getDecision(decision);
            DecisionExpression expression = (DecisionExpression)MAPPER.readValue(decisionText, DecisionExpression.class);
            return expression instanceof DecisionTable && (outputClauses = ((DecisionTable)expression).getOutputClauses()).size() == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        MAPPER.setVisibility(MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
    }
}

