/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.rdf2dmn;

import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.signavio.rdf2dmn.RDFModel;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.time.StopWatch;
import org.w3c.dom.Document;

public class RDFReader {
    protected final BuildLogger logger;

    public RDFReader(BuildLogger logger) {
        this.logger = logger;
    }

    public RDFModel readModel(String modelName, InputStream inputStream) throws Exception {
        this.logger.info(String.format("Reading model '%s'", modelName));
        StopWatch watch = new StopWatch();
        watch.start();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(inputStream);
        RDFModel rdfModel = new RDFModel(document);
        watch.stop();
        this.logger.info("RDF reading time: " + watch.toString());
        return rdfModel;
    }
}

