/*
 * Decompiled with CFR 0.152.
 */
package com.gs.dmn.signavio.rdf2dmn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.gs.dmn.DMNModelRepository;
import com.gs.dmn.ast.ObjectFactory;
import com.gs.dmn.ast.TBuiltinAggregator;
import com.gs.dmn.ast.TDMNElementReference;
import com.gs.dmn.ast.TDecision;
import com.gs.dmn.ast.TDecisionRule;
import com.gs.dmn.ast.TDecisionTable;
import com.gs.dmn.ast.TDefinitions;
import com.gs.dmn.ast.TExpression;
import com.gs.dmn.ast.THitPolicy;
import com.gs.dmn.ast.TInformationItem;
import com.gs.dmn.ast.TInformationRequirement;
import com.gs.dmn.ast.TInputClause;
import com.gs.dmn.ast.TInputData;
import com.gs.dmn.ast.TItemDefinition;
import com.gs.dmn.ast.TLiteralExpression;
import com.gs.dmn.ast.TNamedElement;
import com.gs.dmn.ast.TOutputClause;
import com.gs.dmn.ast.TUnaryTests;
import com.gs.dmn.context.DMNContext;
import com.gs.dmn.dialect.DMNDialectDefinition;
import com.gs.dmn.el.analysis.semantics.type.Type;
import com.gs.dmn.log.BuildLogger;
import com.gs.dmn.runtime.DMNRuntimeException;
import com.gs.dmn.serialization.DMNSerializer;
import com.gs.dmn.serialization.DMNVersion;
import com.gs.dmn.signavio.SignavioDMNModelRepository;
import com.gs.dmn.signavio.dialect.SignavioDMNDialectDefinition;
import com.gs.dmn.signavio.rdf2dmn.RDFModel;
import com.gs.dmn.signavio.rdf2dmn.RDFReader;
import com.gs.dmn.signavio.rdf2dmn.json.AllowedValue;
import com.gs.dmn.signavio.rdf2dmn.json.Context;
import com.gs.dmn.signavio.rdf2dmn.json.EnumItem;
import com.gs.dmn.signavio.rdf2dmn.json.ItemDefinition;
import com.gs.dmn.signavio.rdf2dmn.json.ItemDefinitionRelation;
import com.gs.dmn.signavio.rdf2dmn.json.ToDMNVisitor;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionExpression;
import com.gs.dmn.signavio.rdf2dmn.json.decision.DecisionTable;
import com.gs.dmn.signavio.rdf2dmn.json.decision.HitPolicy;
import com.gs.dmn.signavio.rdf2dmn.json.decision.InputClause;
import com.gs.dmn.signavio.rdf2dmn.json.decision.LiteralExpression;
import com.gs.dmn.signavio.rdf2dmn.json.decision.OutputClause;
import com.gs.dmn.signavio.rdf2dmn.json.decision.Rule;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Expression;
import com.gs.dmn.signavio.rdf2dmn.json.expression.FeelContext;
import com.gs.dmn.signavio.rdf2dmn.json.expression.FunctionCall;
import com.gs.dmn.signavio.rdf2dmn.json.expression.Reference;
import com.gs.dmn.signavio.rdf2dmn.json.relation.EnumerationProperty;
import com.gs.dmn.signavio.rdf2dmn.json.relation.Relation;
import com.gs.dmn.transformation.AbstractFileTransformer;
import com.gs.dmn.transformation.InputParameters;
import com.gs.dmn.transformation.basic.BasicDMNToNativeTransformer;
import com.gs.dmn.transformation.lazy.LazyEvaluationDetector;
import com.gs.dmn.transformation.lazy.NopLazyEvaluationDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RDFToDMNTransformer
extends AbstractFileTransformer {
    public static final String NUMBER_TYPE = "number";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String STRING_TYPE = "string";
    public static final String DATE_TYPE = "date";
    public static final String TIME_TYPE = "time";
    public static final String DATETIME_TYPE = "datetime";
    public static final String DURATION_TYPE = "duration";
    public static final String ENUMERATION_TYPE = "enumeration";
    protected static final List<String> FEEL_DATA_TYPES = Arrays.asList("number", "boolean", "string", "date", "time", "datetime", "duration", "enumeration");
    public static final String RDF_FILE_EXTENSION = ".xml";
    private static final Map<String, String> FUNCTION_RETURN_TYPE = new LinkedHashMap<String, String>();
    private static final ObjectFactory OBJECT_FACTORY;
    private RDFModel rdfModel;
    private final RDFReader rdfReader;
    private final DMNDialectDefinition<?, ?, ?, ?, ?, ?> dialectDefinition = new SignavioDMNDialectDefinition();
    private final BasicDMNToNativeTransformer<Type, DMNContext> dmnTransformer;
    private final DMNSerializer dmnSerializer;

    public static boolean isRDFFile(File file) {
        return file != null && file.isFile() && file.getName().endsWith(RDF_FILE_EXTENSION);
    }

    public RDFToDMNTransformer(InputParameters inputParameters, BuildLogger logger) {
        super(inputParameters, logger);
        this.dmnTransformer = this.dialectDefinition.createBasicTransformer((DMNModelRepository)new SignavioDMNModelRepository(), (LazyEvaluationDetector)new NopLazyEvaluationDetector(), inputParameters);
        this.dmnSerializer = this.dialectDefinition.createDMNSerializer(logger, inputParameters);
        this.rdfReader = new RDFReader(logger);
    }

    protected boolean shouldTransformFile(File inputFile) {
        if (inputFile == null) {
            return false;
        }
        if (inputFile.isDirectory()) {
            return !inputFile.getName().endsWith(".svn");
        }
        return RDFToDMNTransformer.isRDFFile(inputFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformFile(File inputFile, File inputRoot, Path outputPath) {
        if (inputFile.isDirectory()) {
            if (!this.shouldTransformFile(inputFile)) return;
            this.logger.info(String.format("Scanning folder '%s'", inputFile.getPath()));
            File[] files = inputFile.listFiles();
            if (files == null) return;
            for (File child : files) {
                this.transformFile(child, inputRoot, outputPath);
            }
            return;
        } else {
            try {
                if (!this.shouldTransformFile(inputFile)) return;
                this.logger.info(String.format("Transforming file '%s'", inputFile.getPath()));
                this.transformLeaf(inputFile, inputRoot, outputPath);
                return;
            }
            catch (Exception e) {
                throw new DMNRuntimeException(String.format("Failed to transform diagram '%s'", inputFile.getPath()), (Throwable)e);
            }
        }
    }

    private void transformLeaf(File child, File root, Path outputPath) {
        try (FileInputStream inputStream = new FileInputStream(child.toURI().getPath());){
            File outputFolder = this.outputFolder(child, root, outputPath);
            File outputFile = new File(outputFolder, this.diagramName(child) + ".dmn");
            this.logger.info(String.format("Output folder '%s' ", outputFolder.getCanonicalPath()));
            this.logger.info(String.format("Output file %s ...", outputFile.getCanonicalPath()));
            TDefinitions element = this.transform(this.diagramName(child), inputStream);
            this.dmnSerializer.writeModel(element, outputFile);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Error during transforming '%s'.", child.getName()), (Throwable)e);
        }
    }

    private TDefinitions transform(String name, InputStream inputStream) throws Exception {
        this.rdfModel = this.rdfReader.readModel(name, inputStream);
        TDefinitions root = OBJECT_FACTORY.createTDefinitions();
        root.setNamespace(DMNVersion.DMN_11.getNamespace());
        root.setName(name);
        root.getElementInfo().getNsContext().put("", DMNVersion.DMN_11.getNamespace());
        root.getElementInfo().getNsContext().put("feel", DMNVersion.DMN_11.getFeelNamespace());
        root.getElementInfo().getNsContext().put(this.inputParameters.getPrefix(), this.inputParameters.getNamespace());
        this.addItemDefinitions(root);
        this.addDRGElements(root);
        return root;
    }

    private String diagramName(File child) {
        String fileName = child.getName();
        int index = fileName.lastIndexOf(".");
        return fileName.substring(0, index);
    }

    private void addItemDefinitions(TDefinitions root) {
        for (Element decision : this.rdfModel.findAllDecision()) {
            this.addItemDefinitionsForDecision(root, decision);
        }
        for (Element inputData : this.rdfModel.findAllInputData()) {
            this.addItemDefinitionsForInputData(root, inputData);
        }
    }

    private void addItemDefinitionsForDecision(TDefinitions root, Element decision) {
        block9: {
            try {
                String decisionText = this.rdfModel.getDecision(decision);
                DecisionExpression expression = (DecisionExpression)RDFModel.MAPPER.readValue(decisionText, DecisionExpression.class);
                if (expression instanceof DecisionTable) {
                    HitPolicy hitPolicy = ((DecisionTable)expression).getHitPolicy();
                    String aggregation = ((DecisionTable)expression).getAggregation();
                    List<OutputClause> outputClauses = ((DecisionTable)expression).getOutputClauses();
                    if (outputClauses.size() == 0) {
                        throw new IllegalArgumentException(String.format("Cannot create ItemDefinition for '%s' without OutputClauses", this.rdfModel.getAboutAttribute(decision)));
                    }
                    if (outputClauses.size() == 1) {
                        String id = this.makeItemDefinitionId(decision);
                        String decisionName = this.rdfModel.getName(decision);
                        String name = this.makeItemDefinitionName(decisionName);
                        boolean isList = this.isMultipleHit(hitPolicy) != false && this.isMultipleCollect(aggregation);
                        OutputClause oc = outputClauses.get(0);
                        ItemDefinition itemDefinition = oc.getItemDefinition();
                        TItemDefinition decisionItemDefinition = this.makeItemDefinition(id, name, decisionName, isList, itemDefinition);
                        if ("count".equalsIgnoreCase(aggregation)) {
                            decisionItemDefinition.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), NUMBER_TYPE));
                            decisionItemDefinition.setAllowedValues(null);
                            decisionItemDefinition.getItemComponent().clear();
                        }
                        root.getItemDefinition().add(decisionItemDefinition);
                    } else {
                        TItemDefinition decisionItemDefinition = OBJECT_FACTORY.createTItemDefinition();
                        decisionItemDefinition.setId(this.makeItemDefinitionId(decision));
                        String decisionName = this.rdfModel.getName(decision);
                        decisionItemDefinition.setLabel(this.makeLabel(decisionName));
                        decisionItemDefinition.setName(this.makeItemDefinitionName(decisionName));
                        decisionItemDefinition.setIsCollection(this.isMultipleHit(hitPolicy));
                        for (OutputClause oc : outputClauses) {
                            String id = this.makeItemDefinitionId(oc, decision);
                            String name = this.makeItemDefinitionName(oc);
                            String label = oc.getItemDefinition().getName();
                            boolean isList = false;
                            ItemDefinition itemDefinition = oc.getItemDefinition();
                            TItemDefinition itemComponent = this.makeItemDefinition(id, name, label, isList, itemDefinition);
                            decisionItemDefinition.getItemComponent().add(itemComponent);
                        }
                        root.getItemDefinition().add(decisionItemDefinition);
                    }
                    break block9;
                }
                if (expression instanceof LiteralExpression) {
                    String id = this.makeItemDefinitionId(decision);
                    String decisionName = this.rdfModel.getName(decision);
                    boolean isList = false;
                    String name = this.makeItemDefinitionName(decisionName);
                    TItemDefinition decisionItemDefinition = this.makeItemDefinition(id, name, decisionName, isList, ((LiteralExpression)expression).getItemDefinition());
                    root.getItemDefinition().add(decisionItemDefinition);
                    break block9;
                }
                throw new IllegalArgumentException(String.format("Cannot create ItemDefinition for '%s'", this.rdfModel.getAboutAttribute(decision)));
            }
            catch (Exception e) {
                throw new DMNRuntimeException((Throwable)e);
            }
        }
    }

    private TItemDefinition makeItemDefinition(String id, String name, String label, boolean isList, ItemDefinition itemDefinition) {
        String type = itemDefinition.getType();
        if (this.isFEELType(type)) {
            TItemDefinition itemComponent = OBJECT_FACTORY.createTItemDefinition();
            itemComponent.setId(id);
            itemComponent.setLabel(this.makeLabel(label));
            itemComponent.setName(name);
            itemComponent.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), this.convertType(type)));
            itemComponent.setIsCollection(Boolean.valueOf(isList || itemDefinition.isList()));
            List<EnumItem> enumItems = itemDefinition.getEnumItems();
            if (enumItems != null) {
                TUnaryTests value = OBJECT_FACTORY.createTUnaryTests();
                value.setText(this.transformAllowedValues(enumItems));
                itemComponent.setAllowedValues(value);
            }
            return itemComponent;
        }
        if ("complex".equals(type)) {
            TItemDefinition decisionItemDefinition = OBJECT_FACTORY.createTItemDefinition();
            decisionItemDefinition.setId(id);
            decisionItemDefinition.setLabel(this.makeLabel(label));
            decisionItemDefinition.setName(name);
            decisionItemDefinition.setIsCollection(Boolean.valueOf(isList || itemDefinition.isList()));
            List<ItemDefinitionRelation> relations = itemDefinition.getRelations();
            for (ItemDefinitionRelation rel : relations) {
                String relId = rel.getRelationId();
                String relName = rel.getGitemTitle();
                String relLabel = rel.getTitle();
                boolean relIsList = rel.getValue().getList();
                String relType = rel.getValue().getType();
                TItemDefinition relComponent = OBJECT_FACTORY.createTItemDefinition();
                relComponent.setId(relId);
                relComponent.setLabel(this.makeLabel(relLabel));
                relComponent.setName(relName);
                relComponent.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), this.convertType(relType)));
                relComponent.setIsCollection(Boolean.valueOf(relIsList));
                decisionItemDefinition.getItemComponent().add(relComponent);
            }
            return decisionItemDefinition;
        }
        throw new UnsupportedOperationException(String.format("Not supported type '%s'", type));
    }

    private Boolean isMultipleHit(HitPolicy hitPolicy) {
        return HitPolicy.noOrder == hitPolicy || HitPolicy.outputOrder == hitPolicy || HitPolicy.ruleOrder == hitPolicy;
    }

    private boolean isMultipleCollect(String aggregation) {
        return !"count".equalsIgnoreCase(aggregation) && !"min".equalsIgnoreCase(aggregation) && !"max".equalsIgnoreCase(aggregation) && !"sum".equalsIgnoreCase(aggregation);
    }

    private void addItemDefinitionsForInputData(TDefinitions root, Element resource) {
        if (this.rdfModel.isInputData(resource)) {
            String typeName = this.rdfModel.getFEELType(resource);
            if (this.hasRelations(resource)) {
                TItemDefinition itemDefinition = OBJECT_FACTORY.createTItemDefinition();
                itemDefinition.setId(this.makeItemDefinitionId(resource));
                itemDefinition.setLabel(this.makeLabel(this.rdfModel.getLabel(resource)));
                itemDefinition.setName(this.makeItemDefinitionName(resource));
                Boolean isCollection = this.rdfModel.isList(resource);
                itemDefinition.setIsCollection(isCollection);
                List<Relation> relations = this.rdfModel.getRelationList(this.rdfModel.getRelations(resource));
                for (Relation relation : relations) {
                    TItemDefinition itemComponent = OBJECT_FACTORY.createTItemDefinition();
                    itemComponent.setId(this.makeItemDefinitionId(relation));
                    itemComponent.setLabel(this.makeLabel(relation.getTitle()));
                    itemComponent.setName(this.makeItemDefinitionName(relation));
                    String type = relation.getValue().getType();
                    if (FEEL_DATA_TYPES.contains(type)) {
                        List<EnumItem> enumItems;
                        itemComponent.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), type));
                        if (relation.getValue() instanceof EnumerationProperty && (enumItems = ((EnumerationProperty)relation.getValue()).getEnumItems()) != null) {
                            TUnaryTests value = OBJECT_FACTORY.createTUnaryTests();
                            value.setText(this.transformAllowedValues(enumItems));
                            itemComponent.setAllowedValues(value);
                        }
                    } else {
                        throw new UnsupportedOperationException(String.format("Not supported FEEL type '%s'", type));
                    }
                    itemComponent.setIsCollection(Boolean.valueOf(relation.isList()));
                    itemDefinition.getItemComponent().add(itemComponent);
                }
                root.getItemDefinition().add(itemDefinition);
            } else if (this.isFEELType(typeName)) {
                TItemDefinition itemDefinition = OBJECT_FACTORY.createTItemDefinition();
                itemDefinition.setId(this.makeItemDefinitionId(resource));
                itemDefinition.setLabel(this.makeLabel(this.rdfModel.getLabel(resource)));
                itemDefinition.setName(this.makeItemDefinitionName(resource));
                itemDefinition.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), typeName));
                Boolean isCollection = this.rdfModel.isList(resource);
                itemDefinition.setIsCollection(isCollection);
                TUnaryTests value = OBJECT_FACTORY.createTUnaryTests();
                String enumItems = this.rdfModel.getObject(resource, "enumitems");
                if (!StringUtils.isBlank((CharSequence)enumItems)) {
                    value.setText(this.transformAllowedValues(enumItems));
                    itemDefinition.setAllowedValues(value);
                }
                root.getItemDefinition().add(itemDefinition);
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot create ItemDefinition for '%s'", this.rdfModel.getAboutAttribute(resource)));
        }
    }

    private String makeItemDefinitionId(Element decision) {
        return String.format("item-definition-%s", this.rdfModel.getAboutAttribute(decision));
    }

    private String makeItemDefinitionId(OutputClause oc, Element decision) {
        return String.format("item-definition-%s-%s", this.rdfModel.getAboutAttribute(decision), oc.getId());
    }

    private String makeItemDefinitionId(Relation relation) {
        return String.format("item-definition-%s-%s", relation.getTitle().toLowerCase(), relation.getRelationId());
    }

    private String makeItemDefinitionName(Element resource) {
        try {
            String name = this.rdfModel.getName(resource);
            return this.makeItemDefinitionName(name);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot make ItemDefinition for resource '%s'", this.rdfModel.getAboutAttribute(resource)), (Throwable)e);
        }
    }

    private String makeItemDefinitionName(Relation relation) {
        return this.makeItemDefinitionName(relation.getTitle());
    }

    private String makeItemDefinitionName(OutputClause oc) {
        try {
            String name = oc.getItemDefinition().getName();
            return this.makeItemDefinitionName(name);
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot make ItemDefinition for output clause '%s'", oc.getId()), (Throwable)e);
        }
    }

    String makeItemDefinitionName(String name) {
        return this.dmnTransformer.nativeFriendlyVariableName(name);
    }

    String makeDecisionName(String name) {
        return this.makeItemDefinitionName(name);
    }

    String makeDecisionVariableName(String name) {
        return this.makeDecisionName(name);
    }

    private void addDRGElements(TDefinitions root) {
        for (Element decision : this.rdfModel.findAllDecision()) {
            TDecision tDecision = this.makeDecision(root, decision);
            root.getDrgElement().add(tDecision);
        }
        for (Element inputData : this.rdfModel.findAllInputData()) {
            TInputData tInputData = this.makeInputData(inputData);
            root.getDrgElement().add(tInputData);
        }
    }

    private TDecision makeDecision(TDefinitions root, Element resource) {
        TDecision decision = OBJECT_FACTORY.createTDecision();
        this.setNamedElementProperties((TNamedElement)decision, resource);
        this.addInformationRequirements(decision, resource);
        decision.setVariable(this.makeDecisionVariable(resource, decision));
        TExpression expression = this.makeExpression(root, resource);
        decision.setExpression(expression);
        return decision;
    }

    private void addInformationRequirements(TDecision tDecision, Element decision) {
        List tInformationRequirements = tDecision.getInformationRequirement();
        List<Element> objects = this.rdfModel.findAllObjects(decision, "target");
        for (Element object : objects) {
            String irId = this.rdfModel.getResourceAttribute(object);
            List<Element> allInformationRequirement = this.rdfModel.findAllInformationRequirement();
            for (Element informationRequirement : allInformationRequirement) {
                if (!irId.equals(this.rdfModel.getAboutAttribute(informationRequirement))) continue;
                Node target1 = informationRequirement.getElementsByTagName("target").item(0);
                String relatedElementId = target1.getAttributes().getNamedItem("rdf:resource").getNodeValue();
                Element target = this.rdfModel.findDescriptionById(relatedElementId);
                boolean isDecision = this.rdfModel.isDecision(target);
                TInformationRequirement tInformationRequirement = this.makeInformationRequirement(this.rdfModel.getAboutAttribute(target), isDecision);
                tInformationRequirements.add(tInformationRequirement);
            }
        }
    }

    private TInformationItem makeDecisionVariable(Element resource, TDecision decision) {
        TInformationItem item = OBJECT_FACTORY.createTInformationItem();
        item.setId(this.makeDecisionVariableId(resource));
        item.setName(this.makeDecisionVariableName(decision.getName()));
        item.setLabel(this.makeLabel(decision.getName()));
        QName typeRef = this.makeQName(resource);
        item.setTypeRef(typeRef);
        return item;
    }

    private String makeDecisionVariableId(Element resource) {
        return String.format("decision-variable-%s", this.rdfModel.getAboutAttribute(resource));
    }

    private TExpression makeDecisionTable(TDefinitions root, Element decision, DecisionTable decisionTable) {
        TDecisionTable tDecisionTable = OBJECT_FACTORY.createTDecisionTable();
        tDecisionTable.setId(this.makeDecisionExpressionId(decision));
        this.setHitPolicy(decisionTable, tDecisionTable);
        this.setAggregation(decisionTable, tDecisionTable);
        this.addInputClauses(decision, decisionTable, tDecisionTable);
        this.addOutputClauses(decision, decisionTable, tDecisionTable);
        this.addRules(root, decision, decisionTable, tDecisionTable);
        return tDecisionTable;
    }

    private TExpression makeLiteralExpression(TDefinitions root, Element decision, LiteralExpression expression) {
        TLiteralExpression tLiteralExpression = OBJECT_FACTORY.createTLiteralExpression();
        tLiteralExpression.setId(this.makeDecisionExpressionId(decision));
        tLiteralExpression.setText(this.text(expression));
        String expressionLanguage = expression.getExpressionLanguage();
        if (StringUtils.isBlank((CharSequence)expressionLanguage)) {
            tLiteralExpression.setExpressionLanguage("free_text");
        }
        return tLiteralExpression;
    }

    private String makeDecisionExpressionId(Element decision) {
        return String.format("decision-expression-%s", this.rdfModel.getAboutAttribute(decision));
    }

    private void setHitPolicy(DecisionTable decisionTable, TDecisionTable tDecisionTable) {
        HitPolicy hitPolicy = decisionTable.getHitPolicy();
        switch (hitPolicy) {
            case unique: {
                tDecisionTable.setHitPolicy(THitPolicy.UNIQUE);
                break;
            }
            case any: {
                tDecisionTable.setHitPolicy(THitPolicy.ANY);
                break;
            }
            case first: {
                tDecisionTable.setHitPolicy(THitPolicy.FIRST);
                break;
            }
            case priority: {
                tDecisionTable.setHitPolicy(THitPolicy.PRIORITY);
                break;
            }
            case noOrder: {
                tDecisionTable.setHitPolicy(THitPolicy.COLLECT);
                break;
            }
            case outputOrder: {
                tDecisionTable.setHitPolicy(THitPolicy.OUTPUT_ORDER);
                break;
            }
            case ruleOrder: {
                tDecisionTable.setHitPolicy(THitPolicy.RULE_ORDER);
                break;
            }
            default: {
                tDecisionTable.setHitPolicy(THitPolicy.UNIQUE);
            }
        }
    }

    private void setAggregation(DecisionTable decisionTable, TDecisionTable tDecisionTable) {
        String aggregation = decisionTable.getAggregation();
        if ("sum".equalsIgnoreCase(aggregation)) {
            tDecisionTable.setAggregation(TBuiltinAggregator.SUM);
        } else if ("count".equalsIgnoreCase(aggregation)) {
            tDecisionTable.setAggregation(TBuiltinAggregator.COUNT);
        } else if ("min".equalsIgnoreCase(aggregation)) {
            tDecisionTable.setAggregation(TBuiltinAggregator.MIN);
        } else if ("max".equalsIgnoreCase(aggregation)) {
            tDecisionTable.setAggregation(TBuiltinAggregator.MAX);
        }
    }

    private void addInputClauses(Element decision, DecisionTable decisionTable, TDecisionTable tDecisionTable) {
        List tInputClauses = tDecisionTable.getInput();
        for (InputClause inputClause : decisionTable.getInputClauses()) {
            Expression expression = inputClause.getExpression();
            if (expression instanceof Reference) {
                TInputClause tInputClause = OBJECT_FACTORY.createTInputClause();
                tInputClause.setId(this.makeInputClauseId(inputClause, decision));
                TLiteralExpression tExpression = OBJECT_FACTORY.createTLiteralExpression();
                tExpression.setId(this.makeInputClauseExpressionId(inputClause, decision));
                Reference reference = (Reference)expression;
                tExpression.setTypeRef(this.makeQName(reference));
                tExpression.setText(this.text(reference));
                tInputClause.setInputExpression(tExpression);
                tInputClauses.add(tInputClause);
                continue;
            }
            if (expression instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)expression;
                TInputClause tInputClause = OBJECT_FACTORY.createTInputClause();
                tInputClause.setId(this.makeInputClauseId(inputClause, decision));
                TLiteralExpression tExpression = OBJECT_FACTORY.createTLiteralExpression();
                tExpression.setId(this.makeInputClauseExpressionId(inputClause, decision));
                tExpression.setTypeRef(this.makeQName(functionCall));
                tExpression.setText(this.text(functionCall));
                tInputClause.setInputExpression(tExpression);
                tInputClauses.add(tInputClause);
                continue;
            }
            throw new UnsupportedOperationException(String.format("'%s' not supported in decision '%s'", expression.getClass().getSimpleName(), this.rdfModel.getAboutAttribute(decision)));
        }
    }

    private String text(DecisionExpression text) {
        ToDMNVisitor visitor = new ToDMNVisitor(this.rdfModel, this.inputParameters);
        Context params = new Context();
        return text.accept(visitor, params);
    }

    private String text(Expression text) {
        ToDMNVisitor visitor = new ToDMNVisitor(this.rdfModel, this.inputParameters);
        Context params = new Context();
        return text.accept(visitor, params);
    }

    private String text(FunctionCall functionCall) {
        String functionId = functionCall.getFunctionId();
        String text = functionId + "(";
        List<Expression> parameters = functionCall.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            text = text + parameters.stream().map(this::text).collect(Collectors.joining(", "));
        }
        text = text + ")";
        return text;
    }

    private String text(Reference reference) {
        String resourceId = reference.getShapeId();
        try {
            Element resource = this.rdfModel.findDescriptionById(resourceId);
            StringBuilder text = new StringBuilder(this.dmnTransformer.nativeFriendlyVariableName(this.rdfModel.getName(resource)));
            List<String> pathElements = reference.getPathElements();
            if (pathElements != null) {
                for (String pathElement : pathElements) {
                    String name = this.rdfModel.pathName(resource, pathElement);
                    if (StringUtils.isBlank((CharSequence)name)) continue;
                    text.append(".").append(this.dmnTransformer.nativeFriendlyVariableName(name));
                }
            }
            return text.toString();
        }
        catch (Exception e) {
            throw new DMNRuntimeException(String.format("Cannot build path for reference '%s'", resourceId), (Throwable)e);
        }
    }

    private String makeInputClauseId(InputClause inputClause, Element decision) {
        return String.format("input-clause-%s-%s", this.rdfModel.getAboutAttribute(decision), inputClause.getId());
    }

    private String makeInputClauseExpressionId(InputClause inputClause, Element decision) {
        return String.format("input-clause-exp-%s-%s", this.rdfModel.getAboutAttribute(decision), inputClause.getId());
    }

    private void addOutputClauses(Element decision, DecisionTable decisionTable, TDecisionTable tDecisionTable) {
        List tOutputClauses = tDecisionTable.getOutput();
        List<OutputClause> outputClauses = decisionTable.getOutputClauses();
        String decisionName = this.rdfModel.getName(decision);
        if (outputClauses.size() == 0) {
            throw new DMNRuntimeException(String.format("No OutputClauses for decision '%s'", decisionName));
        }
        if (outputClauses.size() == 1) {
            OutputClause outputClause = outputClauses.get(0);
            ItemDefinition itemDefinition = outputClause.getItemDefinition();
            String outputClauseName = itemDefinition.getName();
            if (StringUtils.isBlank((CharSequence)outputClauseName)) {
                outputClauseName = decisionName;
            }
            TOutputClause tOutputClause = OBJECT_FACTORY.createTOutputClause();
            tOutputClause.setId(this.makeOutputClauseId(outputClause, decision));
            tOutputClause.setName(this.makeOutputClauseName(outputClauseName));
            tOutputClause.setLabel(this.makeLabel(this.rdfModel.getLabel(decision)));
            String type = itemDefinition.getType();
            if (this.isFEELType(type)) {
                tOutputClause.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), this.convertType(type)));
                List<EnumItem> enumItems = itemDefinition.getEnumItems();
                if (enumItems != null) {
                    TUnaryTests unaryTests = new TUnaryTests();
                    unaryTests.setText(this.transformAllowedValues(enumItems));
                    tOutputClause.setOutputValues(unaryTests);
                }
            } else {
                tOutputClause.setTypeRef(this.makeQName(this.inputParameters.getNamespace(), type));
            }
            tOutputClauses.add(tOutputClause);
        } else {
            for (OutputClause outputClause : outputClauses) {
                try {
                    ItemDefinition itemDefinition = outputClause.getItemDefinition();
                    String outputClauseName = itemDefinition.getName();
                    TOutputClause tOutputClause = OBJECT_FACTORY.createTOutputClause();
                    tOutputClause.setId(this.makeOutputClauseId(outputClause, decision));
                    tOutputClause.setName(this.makeOutputClauseName(outputClauseName));
                    tOutputClause.setLabel(this.makeLabel(outputClauseName));
                    String type = itemDefinition.getType();
                    if (this.isFEELType(type)) {
                        tOutputClause.setTypeRef(this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), this.convertType(type)));
                        List<EnumItem> enumItems = itemDefinition.getEnumItems();
                        if (enumItems != null) {
                            TUnaryTests unaryTests = new TUnaryTests();
                            unaryTests.setText(this.transformAllowedValues(enumItems));
                            tOutputClause.setOutputValues(unaryTests);
                        }
                    } else {
                        tOutputClause.setTypeRef(this.makeQName(this.inputParameters.getNamespace(), type));
                    }
                    tOutputClauses.add(tOutputClause);
                }
                catch (Exception e) {
                    throw new DMNRuntimeException(String.format("Cannot process OutputClause '%s'", outputClause.getId()), (Throwable)e);
                }
            }
        }
    }

    private String convertType(String type) {
        return ENUMERATION_TYPE.equals(type) ? STRING_TYPE : type;
    }

    private String makeOutputClauseId(OutputClause oc, Element decision) {
        return String.format("output-clause-%s-%s", this.rdfModel.getAboutAttribute(decision), oc.getId());
    }

    private String makeOutputClauseName(String name) {
        return this.makeItemDefinitionName(name);
    }

    private void addRules(TDefinitions root, Element decision, DecisionTable decisionTable, TDecisionTable tDecisionTable) {
        List tRules = tDecisionTable.getRule();
        List<Rule> rules = decisionTable.getRules();
        for (Rule rule : rules) {
            TDecisionRule tDecisionRule = OBJECT_FACTORY.createTDecisionRule();
            tDecisionRule.setId(this.makeRuleId(rule, decision));
            List inputEntry = tDecisionRule.getInputEntry();
            List<Expression> conditions = rule.getConditions();
            ToDMNVisitor visitor = new ToDMNVisitor(this.rdfModel, this.inputParameters);
            for (int conditionIndex = 0; conditionIndex < conditions.size(); ++conditionIndex) {
                Expression condition = conditions.get(conditionIndex);
                TUnaryTests unaryTests = OBJECT_FACTORY.createTUnaryTests();
                FeelContext context = new FeelContext(decision, this.rdfModel, decisionTable, conditionIndex, true);
                unaryTests.setText(condition.accept(visitor, context));
                inputEntry.add(unaryTests);
            }
            List outputEntry = tDecisionRule.getOutputEntry();
            List<Expression> conclusions = rule.getConclusions();
            for (int conclusionIndex = 0; conclusionIndex < conclusions.size(); ++conclusionIndex) {
                Expression conclusion = conclusions.get(conclusionIndex);
                TLiteralExpression expression = OBJECT_FACTORY.createTLiteralExpression();
                FeelContext context = new FeelContext(decision, this.rdfModel, decisionTable, conclusionIndex, false);
                String accept = conclusion.accept(visitor, context);
                expression.setText(accept);
                outputEntry.add(expression);
            }
            tRules.add(tDecisionRule);
        }
    }

    private String makeRuleId(Rule rule, Element decision) {
        return String.format("rule-%s-%s", this.rdfModel.getAboutAttribute(decision), rule.getId());
    }

    private TInputData makeInputData(Element resource) {
        TInputData inputData = OBJECT_FACTORY.createTInputData();
        this.setNamedElementProperties((TNamedElement)inputData, resource);
        inputData.setVariable(this.makeInputDataVariable(resource, inputData));
        return inputData;
    }

    private TInformationItem makeInputDataVariable(Element resource, TInputData inputData) {
        TInformationItem item = OBJECT_FACTORY.createTInformationItem();
        item.setId(this.makeInputDataVariableId(resource));
        item.setName(inputData.getName());
        item.setLabel(this.makeLabel(inputData.getName()));
        item.setTypeRef(this.makeQName(this.inputParameters.getNamespace(), this.makeItemDefinitionName(resource)));
        return item;
    }

    private boolean hasRelations(Element resource) {
        return !StringUtils.isBlank((CharSequence)this.rdfModel.getRelations(resource));
    }

    private boolean isFEELType(String type) {
        return FEEL_DATA_TYPES.contains(type);
    }

    private String makeInputDataVariableId(Element resource) {
        return String.format("input-data-variable-%s", this.rdfModel.getAboutAttribute(resource));
    }

    private String transformAllowedValues(List<EnumItem> enumItems) {
        return enumItems.stream().map(ei -> String.format("\"%s\"", ei.getTitle())).collect(Collectors.joining(", "));
    }

    private String transformAllowedValues(String enumItems) {
        try {
            List allowedValues = (List)RDFModel.MAPPER.readValue(enumItems, (TypeReference)new TypeReference<List<AllowedValue>>(){});
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < allowedValues.size(); ++i) {
                AllowedValue allowedValue = (AllowedValue)allowedValues.get(i);
                if (i != 0) {
                    result.append(", ");
                }
                result.append(String.format("\"%s\"", allowedValue.getTitle()));
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new DMNRuntimeException(String.format("Cannot process AllowedValues for '%s'", enumItems), (Throwable)e);
        }
    }

    private TInformationRequirement makeInformationRequirement(String resourceId, boolean isDecision) {
        TInformationRequirement ir = OBJECT_FACTORY.createTInformationRequirement();
        TDMNElementReference reference = OBJECT_FACTORY.createTDMNElementReference();
        reference.setHref(resourceId);
        if (isDecision) {
            ir.setRequiredDecision(reference);
        } else {
            ir.setRequiredInput(reference);
        }
        return ir;
    }

    private TExpression makeExpression(TDefinitions root, Element decision) {
        String decisionText = this.rdfModel.getDecision(decision);
        if (!StringUtils.isBlank((CharSequence)decisionText)) {
            try {
                DecisionExpression expression = (DecisionExpression)RDFModel.MAPPER.readValue(decisionText, DecisionExpression.class);
                if (expression instanceof DecisionTable) {
                    return this.makeDecisionTable(root, decision, (DecisionTable)expression);
                }
                if (expression instanceof LiteralExpression) {
                    return this.makeLiteralExpression(root, decision, (LiteralExpression)expression);
                }
                throw new DMNRuntimeException(String.format("Cannot make expression for decision '%s'", decision.getAttribute("id")));
            }
            catch (IOException e) {
                throw new DMNRuntimeException(String.format("Cannot make expression for decision %s", decision.getAttribute("id")), (Throwable)e);
            }
        }
        return null;
    }

    private void setNamedElementProperties(TNamedElement element, Element resource) {
        element.setId(this.rdfModel.getAboutAttribute(resource));
        element.setLabel(this.makeLabel(this.rdfModel.getLabel(resource)));
        element.setName(this.makeDecisionName(this.rdfModel.getName(resource)));
    }

    private QName makeQName(Reference reference) {
        String resourceId = reference.getShapeId();
        Element resource = this.rdfModel.findDescriptionById(resourceId);
        return this.makeQName(resource);
    }

    private QName makeQName(FunctionCall functionCall) {
        String functionId = functionCall.getFunctionId();
        String returnType = FUNCTION_RETURN_TYPE.get(functionId);
        if (returnType != null) {
            return this.makeQName(DMNVersion.DMN_11.getFeelNamespace(), STRING_TYPE);
        }
        throw new UnsupportedOperationException(String.format("'%s' function not supported yet", functionId));
    }

    private QName makeQName(Element resource) {
        return this.makeQName(this.inputParameters.getNamespace(), this.makeItemDefinitionName(resource));
    }

    private QName makeQName(String namespace, String name) {
        String cleanName = this.dmnTransformer.nativeFriendlyName(name);
        String prefix = "";
        if (DMNVersion.DMN_11.getFeelNamespace().equals(namespace)) {
            prefix = "feel";
        } else if (this.inputParameters.getNamespace().equals(namespace)) {
            prefix = this.inputParameters.getPrefix();
        }
        return new QName(namespace, cleanName, prefix);
    }

    private String makeLabel(String label) {
        return label == null ? null : label.trim();
    }

    static {
        FUNCTION_RETURN_TYPE.put("concat", STRING_TYPE);
        FUNCTION_RETURN_TYPE.put("count", NUMBER_TYPE);
        OBJECT_FACTORY = new ObjectFactory();
    }
}

